/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;
import org.joda.time.ReadableInstant;

public class DateTimeDeserializer
extends JodaDeserializerBase<ReadableInstant> {
    public DateTimeDeserializer(Class<? extends ReadableInstant> clazz) {
        super(clazz);
    }

    public static <T extends ReadableInstant> JsonDeserializer<T> forType(Class<T> clazz) {
        return new DateTimeDeserializer((Class<? extends ReadableInstant>)clazz);
    }

    public ReadableDateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return new DateTime(jsonParser.getLongValue(), DateTimeZone.forTimeZone((TimeZone)deserializationContext.getTimeZone()));
        }
        if (jsonToken == JsonToken.VALUE_STRING) {
            String string = jsonParser.getText().trim();
            if (string.length() == 0) {
                return null;
            }
            return new DateTime((Object)string, DateTimeZone.forTimeZone((TimeZone)deserializationContext.getTimeZone()));
        }
        throw deserializationContext.mappingException(this.getValueClass());
    }
}

