/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.service;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.metamx.common.ISE;
import com.metamx.emitter.service.ServiceEvent;
import com.metamx.emitter.service.ServiceEventBuilder;
import java.util.Arrays;
import java.util.Map;
import org.joda.time.DateTime;

public class ServiceMetricEvent
implements ServiceEvent {
    private final DateTime createdTime;
    private final String service;
    private final String host;
    private final Map<String, Object> userDims;
    private final String metric;
    private final Number value;

    public static Builder builder() {
        return new Builder();
    }

    private ServiceMetricEvent(DateTime createdTime, String service, String host, Map<String, Object> userDims, String metric, Number value) {
        this.createdTime = createdTime != null ? createdTime : new DateTime();
        this.service = service;
        this.host = host;
        this.userDims = userDims;
        this.metric = metric;
        this.value = value;
    }

    @Override
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getFeed() {
        return "metrics";
    }

    @Override
    public String getService() {
        return this.service;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public Map<String, Object> getUserDims() {
        return ImmutableMap.copyOf(this.userDims);
    }

    public String getMetric() {
        return this.metric;
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean isSafeToBuffer() {
        return true;
    }

    @Override
    @JsonValue
    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put((Object)"feed", (Object)this.getFeed()).put((Object)"timestamp", (Object)this.createdTime.toString()).put((Object)"service", (Object)this.service).put((Object)"host", (Object)this.host).put((Object)"metric", (Object)this.metric).put((Object)"value", (Object)this.value).putAll(Maps.filterEntries(this.userDims, (Predicate)new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return input.getKey() != null;
            }
        })).build();
    }

    public static class Builder {
        private final Map<String, Object> userDims = Maps.newTreeMap();

        public Builder setUser1(String[] x) {
            this.userDims.put("user1", Arrays.asList(x));
            return this;
        }

        public Builder setUser2(String[] x) {
            this.userDims.put("user2", Arrays.asList(x));
            return this;
        }

        public Builder setUser3(String[] x) {
            this.userDims.put("user3", Arrays.asList(x));
            return this;
        }

        public Builder setUser4(String[] x) {
            this.userDims.put("user4", Arrays.asList(x));
            return this;
        }

        public Builder setUser5(String[] x) {
            this.userDims.put("user5", Arrays.asList(x));
            return this;
        }

        public Builder setUser6(String[] x) {
            this.userDims.put("user6", Arrays.asList(x));
            return this;
        }

        public Builder setUser7(String[] x) {
            this.userDims.put("user7", Arrays.asList(x));
            return this;
        }

        public Builder setUser8(String[] x) {
            this.userDims.put("user8", Arrays.asList(x));
            return this;
        }

        public Builder setUser9(String[] x) {
            this.userDims.put("user9", Arrays.asList(x));
            return this;
        }

        public Builder setUser10(String[] x) {
            this.userDims.put("user10", Arrays.asList(x));
            return this;
        }

        public Builder setUser1(String x) {
            this.userDims.put("user1", x);
            return this;
        }

        public Builder setUser2(String x) {
            this.userDims.put("user2", x);
            return this;
        }

        public Builder setUser3(String x) {
            this.userDims.put("user3", x);
            return this;
        }

        public Builder setUser4(String x) {
            this.userDims.put("user4", x);
            return this;
        }

        public Builder setUser5(String x) {
            this.userDims.put("user5", x);
            return this;
        }

        public Builder setUser6(String x) {
            this.userDims.put("user6", x);
            return this;
        }

        public Builder setUser7(String x) {
            this.userDims.put("user7", x);
            return this;
        }

        public Builder setUser8(String x) {
            this.userDims.put("user8", x);
            return this;
        }

        public Builder setUser9(String x) {
            this.userDims.put("user9", x);
            return this;
        }

        public Builder setUser10(String x) {
            this.userDims.put("user10", x);
            return this;
        }

        public Object getUser1() {
            return this.userDims.get("user1");
        }

        public Object getUser2() {
            return this.userDims.get("user2");
        }

        public Object getUser3() {
            return this.userDims.get("user3");
        }

        public Object getUser4() {
            return this.userDims.get("user4");
        }

        public Object getUser5() {
            return this.userDims.get("user5");
        }

        public Object getUser6() {
            return this.userDims.get("user6");
        }

        public Object getUser7() {
            return this.userDims.get("user7");
        }

        public Object getUser8() {
            return this.userDims.get("user8");
        }

        public Object getUser9() {
            return this.userDims.get("user9");
        }

        public Object getUser10() {
            return this.userDims.get("user10");
        }

        public ServiceEventBuilder<ServiceMetricEvent> build(String metric, Number value) {
            return this.build(null, metric, value);
        }

        public ServiceEventBuilder<ServiceMetricEvent> build(final DateTime createdTime, final String metric, final Number value) {
            if (Double.isNaN(value.doubleValue())) {
                throw new ISE("Value of NaN is not allowed!", new Object[0]);
            }
            if (Double.isInfinite(value.doubleValue())) {
                throw new ISE("Value of Infinite is not allowed!", new Object[0]);
            }
            return new ServiceEventBuilder<ServiceMetricEvent>(){

                @Override
                public ServiceMetricEvent build(String service, String host) {
                    return new ServiceMetricEvent(createdTime, service, host, Builder.this.userDims, metric, value);
                }
            };
        }
    }
}

