/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.Event;
import com.metamx.emitter.core.HttpEmitterConfig;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.response.ClientResponse;
import com.metamx.http.client.response.HttpResponseHandler;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class HttpPostEmitter
implements Flushable,
Closeable,
Emitter {
    private static final int MAX_EVENT_SIZE = 1047552;
    private static final Logger log = new Logger(HttpPostEmitter.class);
    private static final AtomicInteger instanceCounter = new AtomicInteger();
    private final HttpEmitterConfig config;
    private final HttpClient client;
    private final ObjectMapper jsonMapper;
    private final AtomicReference<List<byte[]>> eventsList = new AtomicReference<LinkedList>(Lists.newLinkedList());
    private final AtomicInteger count = new AtomicInteger(0);
    private final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(String.format("HttpPostEmitter-%s-%%s", instanceCounter.incrementAndGet())).build());
    private final AtomicLong version = new AtomicLong(0L);
    private final AtomicBoolean started = new AtomicBoolean(false);

    public HttpPostEmitter(HttpEmitterConfig config, HttpClient client) {
        this(config, client, new ObjectMapper());
    }

    public HttpPostEmitter(HttpEmitterConfig config, HttpClient client, ObjectMapper jsonMapper) {
        this.config = config;
        this.client = client;
        this.jsonMapper = jsonMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStart
    public void start() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.getAndSet(true)) {
                this.exec.schedule(new EmittingRunnable(this.version.get()), this.config.getFlushMillis(), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Event event) {
        byte[] eventBytes;
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get()) {
                throw new RejectedExecutionException("Service is closed.");
            }
        }
        try {
            eventBytes = this.jsonMapper.writeValueAsBytes((Object)event);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        if (eventBytes.length > 1047552) {
            log.error("Event too large to emit (%,d > %,d): %s ...", new Object[]{eventBytes.length, 1047552, new String(eventBytes, 0, 1047552)});
            return;
        }
        AtomicReference<List<byte[]>> atomicReference = this.eventsList;
        synchronized (atomicReference) {
            this.eventsList.get().add(eventBytes);
        }
        if (!event.isSafeToBuffer() || this.count.incrementAndGet() >= this.config.getFlushCount()) {
            this.exec.execute(new EmittingRunnable(this.version.get()));
        }
    }

    @Override
    public void flush() throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        if (this.started.get()) {
            final EmittingRunnable emittingRunnable = new EmittingRunnable(this.version.get());
            this.exec.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        emittingRunnable.run();
                    }
                    finally {
                        log.debug("Counting down", new Object[0]);
                        latch.countDown();
                    }
                }
            });
            try {
                latch.await();
                log.debug("Awaited Latch", new Object[0]);
            }
            catch (InterruptedException e) {
                log.debug("Thread Interrupted", new Object[0]);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void close() throws IOException {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            this.flush();
            this.started.set(false);
            this.exec.shutdown();
        }
    }

    ScheduledExecutorService getExec() {
        return this.exec;
    }

    private class EmittingRunnable
    implements Runnable {
        private final long instantiatedVersion;

        public EmittingRunnable(long instantiatedVersion) {
            this.instantiatedVersion = instantiatedVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long currVersion;
            block14: {
                currVersion = HttpPostEmitter.this.version.get();
                try {
                    List events;
                    if (!HttpPostEmitter.this.started.get()) {
                        log.info("Not started, skipping...", new Object[0]);
                        return;
                    }
                    if (this.instantiatedVersion != currVersion) {
                        log.debug("Skipping because instantiatedVersion[%s] != currVersion[%s]", new Object[]{this.instantiatedVersion, currVersion});
                        return;
                    }
                    HttpPostEmitter.this.count.set(0);
                    currVersion = HttpPostEmitter.this.version.incrementAndGet();
                    AtomicReference atomicReference = HttpPostEmitter.this.eventsList;
                    synchronized (atomicReference) {
                        events = HttpPostEmitter.this.eventsList.getAndSet(Lists.newLinkedList());
                    }
                    log.debug("Running export with version[%s] and eventsList size[%s]", new Object[]{this.instantiatedVersion, events.size()});
                    if (events.isEmpty()) break block14;
                    try {
                        ByteArrayOutputStream baos = this.serializeList(events);
                        URL url = new URL(HttpPostEmitter.this.config.getRecipientBaseUrl());
                        log.debug("url[%s] events.size[%s]", new Object[]{url, events.size()});
                        HttpPostEmitter.this.client.post(url).setContent("application/json", baos.toByteArray()).go((HttpResponseHandler)new HttpResponseHandler<Object, Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public ClientResponse<Object> handleResponse(HttpResponse httpResponse) {
                                if (httpResponse.getStatus().getCode() / 100 != 2) {
                                    log.warn("Emissions of events not successful[%s], with message[%s].", new Object[]{httpResponse.getStatus(), httpResponse.getContent().toString(Charsets.UTF_8)});
                                    AtomicReference atomicReference = HttpPostEmitter.this.eventsList;
                                    synchronized (atomicReference) {
                                        ((List)HttpPostEmitter.this.eventsList.get()).addAll(events);
                                    }
                                }
                                return ClientResponse.finished(null);
                            }

                            public ClientResponse<Object> handleChunk(ClientResponse<Object> response, HttpChunk httpChunk) {
                                return response;
                            }

                            public ClientResponse<Object> done(ClientResponse<Object> response) {
                                return response;
                            }
                        }).get();
                    }
                    catch (MalformedURLException e) {
                        log.error((Throwable)e, "Cannot post events!!!  Misconfigured or something? Bad urlString[%s]", new Object[]{HttpPostEmitter.this.config.getRecipientBaseUrl()});
                    }
                    catch (JsonProcessingException e) {
                        log.error((Throwable)e, "Couldn't generate JSON objects? urlString[%s]", new Object[]{HttpPostEmitter.this.config.getRecipientBaseUrl()});
                    }
                    catch (Exception e) {
                        log.warn((Throwable)e, "Got exception when posting events to urlString[%s].  Resubmitting.", new Object[]{HttpPostEmitter.this.config.getRecipientBaseUrl()});
                        AtomicReference atomicReference2 = HttpPostEmitter.this.eventsList;
                        synchronized (atomicReference2) {
                            ((List)HttpPostEmitter.this.eventsList.get()).addAll(events);
                        }
                    }
                }
                catch (Throwable e) {
                    log.error(e, "Uncaught exception in EmittingRunnable.run()", new Object[0]);
                }
            }
            HttpPostEmitter.this.exec.schedule(new EmittingRunnable(currVersion), HttpPostEmitter.this.config.getFlushMillis(), TimeUnit.MILLISECONDS);
        }

        private ByteArrayOutputStream serializeList(List<byte[]> events) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write("[".getBytes(Charsets.UTF_8));
            Iterator<byte[]> eventsIter = events.iterator();
            baos.write(eventsIter.next());
            while (eventsIter.hasNext()) {
                baos.write(",".getBytes(Charsets.UTF_8));
                baos.write(eventsIter.next());
            }
            baos.write("]".getBytes());
            return baos;
        }
    }
}

