/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.emitter.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.metamx.common.ISE;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.core.HttpEmitterConfig;
import com.metamx.emitter.core.HttpPostEmitter;
import com.metamx.emitter.core.LoggingEmitter;
import com.metamx.emitter.core.LoggingEmitterConfig;
import com.metamx.http.client.HttpClient;

public class EmitterBuilder {
    @JsonProperty(value="http")
    private HttpEmitterConfig httpEmitterConfig = null;
    @JsonProperty(value="logging")
    private LoggingEmitterConfig loggingEmitterConfig = null;

    public HttpEmitterConfig getHttpEmitterConfig() {
        return this.httpEmitterConfig;
    }

    public void setHttpEmitterConfig(HttpEmitterConfig httpEmitterConfig) {
        this.httpEmitterConfig = httpEmitterConfig;
    }

    public LoggingEmitterConfig getLoggingEmitterConfig() {
        return this.loggingEmitterConfig;
    }

    public void setLoggingEmitterConfig(LoggingEmitterConfig loggingEmitterConfig) {
        this.loggingEmitterConfig = loggingEmitterConfig;
    }

    public Emitter build(ObjectMapper objectMapper, HttpClient httpClient, Lifecycle lifecycle) {
        if (this.loggingEmitterConfig != null) {
            return this.buildLogging(objectMapper, lifecycle);
        }
        if (this.httpEmitterConfig != null) {
            return this.buildHttp(httpClient, objectMapper, lifecycle);
        }
        throw new ISE("Must specify emitter as either logging or http", new Object[0]);
    }

    public Emitter buildLogging(ObjectMapper objectMapper, Lifecycle lifecycle) {
        LoggingEmitter retVal = new LoggingEmitter(this.loggingEmitterConfig, objectMapper);
        lifecycle.addManagedInstance((Object)retVal);
        return retVal;
    }

    public Emitter buildHttp(HttpClient httpClient, ObjectMapper objectMapper, Lifecycle lifecycle) {
        HttpPostEmitter retVal = new HttpPostEmitter(this.httpEmitterConfig, httpClient, objectMapper);
        lifecycle.addManagedInstance((Object)retVal);
        return retVal;
    }
}

