/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveMessageRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String queueUrl;
    private ListWithAutoConstructFlag<String> attributeNames;
    private Integer maxNumberOfMessages;
    private Integer visibilityTimeout;
    private Integer waitTimeSeconds;

    public ReceiveMessageRequest() {
    }

    public ReceiveMessageRequest(String queueUrl) {
        this.setQueueUrl(queueUrl);
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public ReceiveMessageRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public List<String> getAttributeNames() {
        if (this.attributeNames == null) {
            this.attributeNames = new ListWithAutoConstructFlag();
            this.attributeNames.setAutoConstruct(true);
        }
        return this.attributeNames;
    }

    public void setAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
            return;
        }
        ListWithAutoConstructFlag attributeNamesCopy = new ListWithAutoConstructFlag(attributeNames.size());
        attributeNamesCopy.addAll(attributeNames);
        this.attributeNames = attributeNamesCopy;
    }

    public ReceiveMessageRequest withAttributeNames(String ... attributeNames) {
        if (this.getAttributeNames() == null) {
            this.setAttributeNames(new ArrayList<String>(attributeNames.length));
        }
        for (String value : attributeNames) {
            this.getAttributeNames().add(value);
        }
        return this;
    }

    public ReceiveMessageRequest withAttributeNames(Collection<String> attributeNames) {
        if (attributeNames == null) {
            this.attributeNames = null;
        } else {
            ListWithAutoConstructFlag attributeNamesCopy = new ListWithAutoConstructFlag(attributeNames.size());
            attributeNamesCopy.addAll(attributeNames);
            this.attributeNames = attributeNamesCopy;
        }
        return this;
    }

    public Integer getMaxNumberOfMessages() {
        return this.maxNumberOfMessages;
    }

    public void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
    }

    public ReceiveMessageRequest withMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
        return this;
    }

    public Integer getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public void setVisibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
    }

    public ReceiveMessageRequest withVisibilityTimeout(Integer visibilityTimeout) {
        this.visibilityTimeout = visibilityTimeout;
        return this;
    }

    public Integer getWaitTimeSeconds() {
        return this.waitTimeSeconds;
    }

    public void setWaitTimeSeconds(Integer waitTimeSeconds) {
        this.waitTimeSeconds = waitTimeSeconds;
    }

    public ReceiveMessageRequest withWaitTimeSeconds(Integer waitTimeSeconds) {
        this.waitTimeSeconds = waitTimeSeconds;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ",");
        }
        if (this.getAttributeNames() != null) {
            sb.append("AttributeNames: " + this.getAttributeNames() + ",");
        }
        if (this.getMaxNumberOfMessages() != null) {
            sb.append("MaxNumberOfMessages: " + this.getMaxNumberOfMessages() + ",");
        }
        if (this.getVisibilityTimeout() != null) {
            sb.append("VisibilityTimeout: " + this.getVisibilityTimeout() + ",");
        }
        if (this.getWaitTimeSeconds() != null) {
            sb.append("WaitTimeSeconds: " + this.getWaitTimeSeconds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeNames() == null ? 0 : this.getAttributeNames().hashCode());
        hashCode = 31 * hashCode + (this.getMaxNumberOfMessages() == null ? 0 : this.getMaxNumberOfMessages().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityTimeout() == null ? 0 : this.getVisibilityTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getWaitTimeSeconds() == null ? 0 : this.getWaitTimeSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiveMessageRequest)) {
            return false;
        }
        ReceiveMessageRequest other = (ReceiveMessageRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getAttributeNames() == null ^ this.getAttributeNames() == null) {
            return false;
        }
        if (other.getAttributeNames() != null && !other.getAttributeNames().equals(this.getAttributeNames())) {
            return false;
        }
        if (other.getMaxNumberOfMessages() == null ^ this.getMaxNumberOfMessages() == null) {
            return false;
        }
        if (other.getMaxNumberOfMessages() != null && !other.getMaxNumberOfMessages().equals(this.getMaxNumberOfMessages())) {
            return false;
        }
        if (other.getVisibilityTimeout() == null ^ this.getVisibilityTimeout() == null) {
            return false;
        }
        if (other.getVisibilityTimeout() != null && !other.getVisibilityTimeout().equals(this.getVisibilityTimeout())) {
            return false;
        }
        if (other.getWaitTimeSeconds() == null ^ this.getWaitTimeSeconds() == null) {
            return false;
        }
        return other.getWaitTimeSeconds() == null || other.getWaitTimeSeconds().equals(this.getWaitTimeSeconds());
    }
}

