/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.buffered;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sqs.model.BatchResultErrorEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResultEntry;
import com.amazonaws.services.sqs.model.SendMessageResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultConverter {
    ResultConverter() {
    }

    static SendMessageResult convert(SendMessageBatchResultEntry br) {
        SendMessageResult toReturn = new SendMessageResult();
        toReturn.setMD5OfMessageBody(br.getMD5OfMessageBody());
        toReturn.setMessageId(br.getMessageId());
        return toReturn;
    }

    static Exception convert(BatchResultErrorEntry be) {
        AmazonServiceException toReturn = new AmazonServiceException(be.getMessage());
        toReturn.setErrorCode(be.getCode());
        toReturn.setErrorType(be.isSenderFault() != false ? AmazonServiceException.ErrorType.Client : AmazonServiceException.ErrorType.Service);
        toReturn.setServiceName("AmazonSQS");
        return toReturn;
    }

    public static <X extends AmazonWebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestClientOptions().addClientMarker(userAgent);
        return request;
    }
}

