/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.guava.ser;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class MultimapSerializer
extends JsonSerializer<Multimap<?, ?>>
implements ContextualSerializer {
    private final MapLikeType type;
    private final BeanProperty property;
    private final JsonSerializer<Object> keySerializer;
    private final TypeSerializer valueTypeSerializer;
    private final JsonSerializer<Object> valueSerializer;

    public MultimapSerializer(SerializationConfig serializationConfig, MapLikeType mapLikeType, BeanDescription beanDescription, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer2) {
        this.type = mapLikeType;
        this.property = null;
        this.keySerializer = jsonSerializer;
        this.valueTypeSerializer = typeSerializer;
        this.valueSerializer = jsonSerializer2;
    }

    protected MultimapSerializer(MultimapSerializer multimapSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer2) {
        this.type = multimapSerializer.type;
        this.property = beanProperty;
        this.keySerializer = jsonSerializer;
        this.valueTypeSerializer = typeSerializer;
        this.valueSerializer = jsonSerializer2;
    }

    protected MultimapSerializer withResolved(BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer2) {
        return new MultimapSerializer(this, beanProperty, jsonSerializer, typeSerializer, jsonSerializer2);
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        JsonSerializer jsonSerializer;
        JsonSerializer jsonSerializer2 = this.valueSerializer;
        if (jsonSerializer2 == null) {
            jsonSerializer = this.type.getContentType();
            if (jsonSerializer.isFinal()) {
                jsonSerializer2 = serializerProvider.findValueSerializer(jsonSerializer, beanProperty);
            }
        } else if (jsonSerializer2 instanceof ContextualSerializer) {
            jsonSerializer2 = ((ContextualSerializer)jsonSerializer2).createContextual(serializerProvider, beanProperty);
        }
        jsonSerializer = this.keySerializer;
        if (jsonSerializer == null) {
            jsonSerializer = serializerProvider.findKeySerializer(this.type.getKeyType(), beanProperty);
        } else if (jsonSerializer instanceof ContextualSerializer) {
            jsonSerializer = ((ContextualSerializer)jsonSerializer).createContextual(serializerProvider, beanProperty);
        }
        TypeSerializer typeSerializer = this.valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        return this.withResolved(beanProperty, jsonSerializer, typeSerializer, jsonSerializer2);
    }

    public void serialize(Multimap<?, ?> multimap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        jsonGenerator.writeStartObject();
        if (!multimap.isEmpty()) {
            this.serializeFields(multimap, jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndObject();
    }

    public void serializeWithType(Multimap<?, ?> multimap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException, JsonGenerationException {
        typeSerializer.writeTypePrefixForObject(multimap, jsonGenerator);
        this.serializeFields(multimap, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffixForObject(multimap, jsonGenerator);
    }

    private final void serializeFields(Multimap<?, ?> multimap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            if (this.keySerializer != null) {
                this.keySerializer.serialize(entry.getKey(), jsonGenerator, serializerProvider);
            } else {
                serializerProvider.findKeySerializer(serializerProvider.constructType(String.class), this.property).serialize(entry.getKey(), jsonGenerator, serializerProvider);
            }
            if (this.valueSerializer != null) {
                jsonGenerator.writeStartArray();
                for (Object e : (Collection)entry.getValue()) {
                    this.valueSerializer.serialize(e, jsonGenerator, serializerProvider);
                }
                jsonGenerator.writeEndArray();
                continue;
            }
            serializerProvider.defaultSerializeValue((Object)Lists.newArrayList((Iterable)((Iterable)entry.getValue())), jsonGenerator);
        }
    }
}

