/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.IAE;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.ByteBufferSerializer;
import io.druid.segment.data.ConciseCompressedIndexedInts;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.VSizeIndexed;
import io.druid.segment.data.VSizeIndexedInts;
import io.druid.segment.serde.BitmapIndexColumnPartSupplier;
import io.druid.segment.serde.ColumnPartSerde;
import io.druid.segment.serde.DictionaryEncodedColumnSupplier;
import io.druid.segment.serde.SpatialIndexColumnPartSupplier;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class DictionaryEncodedColumnPartSerde
implements ColumnPartSerde {
    private final GenericIndexed<String> dictionary;
    private final VSizeIndexedInts singleValuedColumn;
    private final VSizeIndexed multiValuedColumn;
    private final GenericIndexed<ImmutableConciseSet> bitmaps;
    private final ImmutableRTree spatialIndex;
    private final long size;

    @JsonCreator
    public static DictionaryEncodedColumnPartSerde createDeserializer(boolean singleValued) {
        return new DictionaryEncodedColumnPartSerde();
    }

    public DictionaryEncodedColumnPartSerde(GenericIndexed<String> dictionary, VSizeIndexedInts singleValCol, VSizeIndexed multiValCol, GenericIndexed<ImmutableConciseSet> bitmaps, ImmutableRTree spatialIndex) {
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValCol;
        this.multiValuedColumn = multiValCol;
        this.bitmaps = bitmaps;
        this.spatialIndex = spatialIndex;
        long size = dictionary.getSerializedSize();
        if (singleValCol != null && multiValCol == null) {
            size += (long)singleValCol.getSerializedSize();
        } else if (singleValCol == null && multiValCol != null) {
            size += (long)multiValCol.getSerializedSize();
        } else {
            throw new IAE("Either singleValCol[%s] or multiValCol[%s] must be set", new Object[]{singleValCol, multiValCol});
        }
        size += bitmaps.getSerializedSize();
        if (spatialIndex != null) {
            size += (long)(spatialIndex.size() + 4);
        }
        this.size = size;
    }

    private DictionaryEncodedColumnPartSerde() {
        this.dictionary = null;
        this.singleValuedColumn = null;
        this.multiValuedColumn = null;
        this.bitmaps = null;
        this.spatialIndex = null;
        this.size = 0L;
    }

    @JsonProperty
    private boolean isSingleValued() {
        return this.singleValuedColumn != null;
    }

    @Override
    public long numBytes() {
        return 1L + this.size;
    }

    @Override
    public void write(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{(byte)(!this.isSingleValued() ? 1 : 0)}));
        this.dictionary.writeToChannel(channel);
        if (this.isSingleValued()) {
            this.singleValuedColumn.writeToChannel(channel);
        } else {
            this.multiValuedColumn.writeToChannel(channel);
        }
        this.bitmaps.writeToChannel(channel);
        if (this.spatialIndex != null) {
            ByteBufferSerializer.writeToChannel(this.spatialIndex, IndexedRTree.objectStrategy, channel);
        }
    }

    @Override
    public ColumnPartSerde read(ByteBuffer buffer, ColumnBuilder builder, ColumnConfig columnConfig) {
        VSizeIndexed multiValuedColumn;
        VSizeIndexedInts singleValuedColumn;
        boolean isSingleValued = buffer.get() == 0;
        GenericIndexed<String> dictionary = GenericIndexed.read(buffer, GenericIndexed.stringStrategy);
        builder.setType(ValueType.STRING);
        if (isSingleValued) {
            singleValuedColumn = VSizeIndexedInts.readFromByteBuffer(buffer);
            multiValuedColumn = null;
            builder.setHasMultipleValues(false).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(dictionary, singleValuedColumn, null, columnConfig.columnCacheSizeBytes()));
        } else {
            singleValuedColumn = null;
            multiValuedColumn = VSizeIndexed.readFromByteBuffer(buffer);
            builder.setHasMultipleValues(true).setDictionaryEncodedColumn(new DictionaryEncodedColumnSupplier(dictionary, null, multiValuedColumn, columnConfig.columnCacheSizeBytes()));
        }
        GenericIndexed<ImmutableConciseSet> bitmaps = GenericIndexed.read(buffer, ConciseCompressedIndexedInts.objectStrategy);
        builder.setBitmapIndex(new BitmapIndexColumnPartSupplier(bitmaps, dictionary));
        ImmutableRTree spatialIndex = null;
        if (buffer.hasRemaining()) {
            spatialIndex = ByteBufferSerializer.read(buffer, IndexedRTree.objectStrategy);
            builder.setSpatialIndex(new SpatialIndexColumnPartSupplier(spatialIndex));
        }
        return new DictionaryEncodedColumnPartSerde(dictionary, singleValuedColumn, multiValuedColumn, bitmaps, spatialIndex);
    }
}

