/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.collect.Lists;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.data.Indexed;
import io.druid.segment.filter.OrFilter;
import io.druid.segment.filter.SelectorFilter;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.util.ArrayList;
import java.util.List;

public class ExtractionFilter
implements Filter {
    private static final int MAX_SIZE = 50000;
    private final String dimension;
    private final String value;
    private final DimExtractionFn fn;

    public ExtractionFilter(String dimension, String value, DimExtractionFn fn) {
        this.dimension = dimension;
        this.value = value;
        this.fn = fn;
    }

    private List<Filter> makeFilters(BitmapIndexSelector selector) {
        Indexed<String> allDimVals = selector.getDimensionValues(this.dimension);
        ArrayList filters = Lists.newArrayList();
        for (int i = 0; i < allDimVals.size(); ++i) {
            String dimVal = allDimVals.get(i);
            if (!this.value.equals(this.fn.apply(dimVal))) continue;
            filters.add(new SelectorFilter(this.dimension, dimVal));
        }
        return filters;
    }

    @Override
    public ImmutableConciseSet goConcise(BitmapIndexSelector selector) {
        return new OrFilter(this.makeFilters(selector)).goConcise(selector);
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        throw new UnsupportedOperationException();
    }
}

