/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.metamx.common.guava.FunctionalIterable;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.query.filter.Filter;
import io.druid.query.filter.ValueMatcher;
import io.druid.query.filter.ValueMatcherFactory;
import io.druid.segment.data.Indexed;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import javax.annotation.Nullable;

class DimensionPredicateFilter
implements Filter {
    private final String dimension;
    private final Predicate<String> predicate;

    public DimensionPredicateFilter(String dimension, Predicate<String> predicate) {
        this.dimension = dimension;
        this.predicate = predicate;
    }

    @Override
    public ImmutableConciseSet goConcise(final BitmapIndexSelector selector) {
        Indexed<String> dimValues = selector.getDimensionValues(this.dimension);
        if (dimValues == null || dimValues.size() == 0 || this.predicate == null) {
            return new ImmutableConciseSet();
        }
        return ImmutableConciseSet.union((Iterable)FunctionalIterable.create(dimValues).filter(this.predicate).transform((Function)new Function<String, ImmutableConciseSet>(){

            public ImmutableConciseSet apply(@Nullable String input) {
                return selector.getConciseInvertedIndex(DimensionPredicateFilter.this.dimension, input);
            }
        }));
    }

    @Override
    public ValueMatcher makeMatcher(ValueMatcherFactory factory) {
        return factory.makeValueMatcher(this.dimension, this.predicate);
    }
}

