/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.metamx.common.guava.CloseQuietly;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.data.CompressedLongBufferObjectStrategy;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedLongs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.List;

public class InMemoryCompressedLongs
implements IndexedLongs {
    private final CompressedLongBufferObjectStrategy strategy;
    private final int sizePer;
    private List<byte[]> compressedBuffers = Lists.newArrayList();
    private int numInserted = 0;
    private int numCompressed = 0;
    private ResourceHolder<LongBuffer> holder = null;
    private LongBuffer loadBuffer = null;
    private int loadBufferIndex = -1;
    private LongBuffer endBuffer;

    public InMemoryCompressedLongs(int sizePer, ByteOrder order) {
        this.sizePer = sizePer;
        this.strategy = CompressedLongBufferObjectStrategy.getBufferForOrder(order);
        this.endBuffer = LongBuffer.allocate(sizePer);
        this.endBuffer.mark();
    }

    @Override
    public int size() {
        return this.numInserted;
    }

    public int add(long value) {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.compressedBuffers.add(this.strategy.toBytes(StupidResourceHolder.create((Object)this.endBuffer)));
            this.endBuffer = LongBuffer.allocate(this.sizePer);
            this.endBuffer.mark();
            this.numCompressed += this.sizePer;
        }
        int retVal = this.numCompressed + this.endBuffer.position();
        this.endBuffer.put(value);
        ++this.numInserted;
        return retVal;
    }

    public int addAll(Iterable<Long> values) {
        int retVal = -1;
        for (Long value : values) {
            retVal = this.add(value);
        }
        return retVal;
    }

    @Override
    public long get(int index) {
        int bufferNum = index / this.sizePer;
        int bufferIndex = index % this.sizePer;
        if (bufferNum == this.compressedBuffers.size()) {
            return this.endBuffer.get(bufferIndex);
        }
        if (bufferNum != this.loadBufferIndex) {
            this.loadBuffer(bufferNum);
        }
        return this.loadBuffer.get(this.loadBuffer.position() + bufferIndex);
    }

    @Override
    public void fill(int index, long[] toFill) {
        if (this.size() - index < toFill.length) {
            throw new IndexOutOfBoundsException(String.format("Cannot fill array of size[%,d] at index[%,d].  Max size[%,d]", toFill.length, index, this.size()));
        }
        int bufferNum = index / this.sizePer;
        int bufferIndex = index % this.sizePer;
        int leftToFill = toFill.length;
        while (leftToFill > 0) {
            if (bufferNum == this.compressedBuffers.size()) {
                this.endBuffer.mark();
                this.endBuffer.position(bufferIndex);
                this.endBuffer.get(toFill, toFill.length - leftToFill, leftToFill);
                this.endBuffer.rewind();
                return;
            }
            if (bufferNum != this.loadBufferIndex) {
                this.loadBuffer(bufferNum);
            }
            this.loadBuffer.mark();
            this.loadBuffer.position(this.loadBuffer.position() + bufferIndex);
            int numToGet = Math.min(this.loadBuffer.remaining(), leftToFill);
            this.loadBuffer.get(toFill, toFill.length - leftToFill, numToGet);
            this.loadBuffer.rewind();
            leftToFill -= numToGet;
            ++bufferNum;
            bufferIndex = 0;
        }
    }

    @Override
    public int binarySearch(long key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int binarySearch(long key, int from, int to) {
        throw new UnsupportedOperationException();
    }

    private void loadBuffer(int bufferNum) {
        this.loadBuffer = null;
        CloseQuietly.close(this.holder);
        byte[] compressedBytes = this.compressedBuffers.get(bufferNum);
        this.holder = this.strategy.fromByteBuffer(ByteBuffer.wrap(compressedBytes), compressedBytes.length);
        this.loadBuffer = (LongBuffer)this.holder.get();
        this.loadBufferIndex = bufferNum;
    }

    public CompressedLongsIndexedSupplier toCompressedLongsIndexedSupplier() {
        LongBuffer longBufCopy = this.endBuffer.asReadOnlyBuffer();
        longBufCopy.flip();
        return new CompressedLongsIndexedSupplier(this.numInserted, this.sizePer, GenericIndexed.fromIterable(Iterables.concat((Iterable)Iterables.transform(this.compressedBuffers, (Function)new Function<byte[], ResourceHolder<LongBuffer>>(){

            public ResourceHolder<LongBuffer> apply(byte[] input) {
                return InMemoryCompressedLongs.this.strategy.fromByteBuffer(ByteBuffer.wrap(input), input.length);
            }
        }), Arrays.asList(StupidResourceHolder.create((Object)longBufCopy))), this.strategy));
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.holder, (boolean)false);
    }
}

