/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import com.google.common.io.InputSupplier;
import com.google.common.primitives.Ints;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.ObjectStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class GenericIndexedWriter<T>
implements Closeable {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final IOPeon ioPeon;
    private final String filenameBase;
    private final ObjectStrategy<T> strategy;
    private boolean objectsSorted = true;
    private T prevObject = null;
    private CountingOutputStream headerOut = null;
    private CountingOutputStream valuesOut = null;
    int numWritten = 0;

    public GenericIndexedWriter(IOPeon ioPeon, String filenameBase, ObjectStrategy<T> strategy) {
        this.ioPeon = ioPeon;
        this.filenameBase = filenameBase;
        this.strategy = strategy;
    }

    public void open() throws IOException {
        this.headerOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("header")));
        this.valuesOut = new CountingOutputStream(this.ioPeon.makeOutputStream(this.makeFilename("values")));
    }

    public void write(T objectToWrite) throws IOException {
        if (this.prevObject != null && this.strategy.compare(this.prevObject, objectToWrite) >= 0) {
            this.objectsSorted = false;
        }
        byte[] bytesToWrite = this.strategy.toBytes(objectToWrite);
        ++this.numWritten;
        this.valuesOut.write(Ints.toByteArray((int)bytesToWrite.length));
        this.valuesOut.write(bytesToWrite);
        this.headerOut.write(Ints.toByteArray((int)((int)this.valuesOut.getCount())));
        this.prevObject = objectToWrite;
    }

    private String makeFilename(String suffix) {
        return String.format("%s.%s", this.filenameBase, suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.headerOut.close();
        this.valuesOut.close();
        long numBytesWritten = this.headerOut.getCount() + this.valuesOut.getCount();
        Preconditions.checkState((this.headerOut.getCount() == (long)(this.numWritten * 4) ? 1 : 0) != 0, (String)"numWritten[%s] number of rows should have [%s] bytes written to headerOut, had[%s]", (Object[])new Object[]{this.numWritten, this.numWritten * 4, this.headerOut.getCount()});
        Preconditions.checkState((numBytesWritten < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Wrote[%s] bytes, which is too many.", (Object[])new Object[]{numBytesWritten});
        try (OutputStream metaOut = this.ioPeon.makeOutputStream(this.makeFilename("meta"));){
            metaOut.write(1);
            metaOut.write(this.objectsSorted ? 1 : 0);
            metaOut.write(Ints.toByteArray((int)((int)numBytesWritten + 4)));
            metaOut.write(Ints.toByteArray((int)this.numWritten));
        }
    }

    public InputSupplier<InputStream> combineStreams() {
        return ByteStreams.join((Iterable)Iterables.transform(Arrays.asList("meta", "header", "values"), (Function)new Function<String, InputSupplier<InputStream>>(){

            public InputSupplier<InputStream> apply(final String input) {
                return new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return GenericIndexedWriter.this.ioPeon.makeInputStream(GenericIndexedWriter.this.makeFilename(input));
                    }
                };
            }
        }));
    }
}

