/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Charsets;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import com.metamx.common.Pair;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.logger.Logger;
import io.druid.segment.data.CacheableObjectStrategy;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.ObjectStrategy;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class GenericIndexed<T>
implements Indexed<T>,
Closeable {
    private static final Logger log = new Logger(GenericIndexed.class);
    private static final byte version = 1;
    public static final int INITIAL_CACHE_CAPACITY = 16384;
    private int indexOffset;
    private final ByteBuffer theBuffer;
    private final ObjectStrategy<T> strategy;
    private final boolean allowReverseLookup;
    private final int size;
    private final boolean cacheable;
    private final ThreadLocal<ByteBuffer> cachedBuffer;
    private final ThreadLocal<SizedLRUMap<Integer, T>> cachedValues;
    private final int valuesOffset;
    public static ObjectStrategy<String> stringStrategy = new CacheableObjectStrategy<String>(){

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public String fromByteBuffer(ByteBuffer buffer, int numBytes) {
            byte[] bytes = new byte[numBytes];
            buffer.get(bytes);
            return new String(bytes, Charsets.UTF_8);
        }

        @Override
        public byte[] toBytes(String val) {
            if (val == null) {
                return new byte[0];
            }
            return val.getBytes(Charsets.UTF_8);
        }

        @Override
        public int compare(String o1, String o2) {
            return Ordering.natural().nullsFirst().compare((Object)o1, (Object)o2);
        }
    };

    public static <T> GenericIndexed<T> fromArray(T[] objects, ObjectStrategy<T> strategy) {
        return GenericIndexed.fromIterable(Arrays.asList(objects), strategy);
    }

    public static <T> GenericIndexed<T> fromIterable(Iterable<T> objectsIterable, ObjectStrategy<T> strategy) {
        Iterator<T> objects = objectsIterable.iterator();
        if (!objects.hasNext()) {
            ByteBuffer buffer = ByteBuffer.allocate(4).putInt(0);
            buffer.flip();
            return new GenericIndexed<T>(buffer, strategy, true);
        }
        boolean allowReverseLookup = true;
        int count = 1;
        T prevVal = objects.next();
        while (objects.hasNext()) {
            T next = objects.next();
            if (strategy.compare(prevVal, next) >= 0) {
                allowReverseLookup = false;
            }
            if (prevVal instanceof Closeable) {
                CloseQuietly.close((Closeable)((Closeable)prevVal));
            }
            prevVal = next;
            ++count;
        }
        if (prevVal instanceof Closeable) {
            CloseQuietly.close((Closeable)((Closeable)prevVal));
        }
        ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(4 + count * 4);
        ByteArrayOutputStream valueBytes = new ByteArrayOutputStream();
        int offset = 0;
        try {
            headerBytes.write(Ints.toByteArray((int)count));
            for (T object : objectsIterable) {
                byte[] bytes = strategy.toBytes(object);
                headerBytes.write(Ints.toByteArray((int)(offset += 4 + bytes.length)));
                valueBytes.write(Ints.toByteArray((int)bytes.length));
                valueBytes.write(bytes);
                if (!(object instanceof Closeable)) continue;
                CloseQuietly.close((Closeable)((Closeable)object));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer theBuffer = ByteBuffer.allocate(headerBytes.size() + valueBytes.size());
        theBuffer.put(headerBytes.toByteArray());
        theBuffer.put(valueBytes.toByteArray());
        theBuffer.flip();
        return new GenericIndexed<T>(theBuffer.asReadOnlyBuffer(), strategy, allowReverseLookup);
    }

    GenericIndexed(ByteBuffer buffer, ObjectStrategy<T> strategy, boolean allowReverseLookup) {
        this.theBuffer = buffer;
        this.strategy = strategy;
        this.allowReverseLookup = allowReverseLookup;
        this.size = this.theBuffer.getInt();
        this.indexOffset = this.theBuffer.position();
        this.valuesOffset = this.theBuffer.position() + (this.size << 2);
        this.cachedBuffer = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return GenericIndexed.this.theBuffer.asReadOnlyBuffer();
            }
        };
        this.cacheable = false;
        this.cachedValues = new ThreadLocal();
    }

    GenericIndexed(GenericIndexed<T> other, final int maxBytes) {
        this.theBuffer = other.theBuffer;
        this.strategy = other.strategy;
        this.allowReverseLookup = other.allowReverseLookup;
        this.size = other.size;
        this.indexOffset = other.indexOffset;
        this.valuesOffset = other.valuesOffset;
        this.cachedBuffer = other.cachedBuffer;
        this.cachedValues = new ThreadLocal<SizedLRUMap<Integer, T>>(){

            @Override
            protected SizedLRUMap<Integer, T> initialValue() {
                log.debug("Allocating column cache of max size[%d]", new Object[]{maxBytes});
                return new SizedLRUMap(16384, maxBytes);
            }
        };
        this.cacheable = this.strategy instanceof CacheableObjectStrategy;
    }

    @Override
    public Class<? extends T> getClazz() {
        return this.strategy.getClazz();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public T get(int index) {
        int endOffset;
        int startOffset;
        T cached;
        if (index < 0) {
            throw new IAE("Index[%s] < 0", new Object[]{index});
        }
        if (index >= this.size) {
            throw new IAE(String.format("Index[%s] >= size[%s]", index, this.size), new Object[0]);
        }
        if (this.cacheable && (cached = this.cachedValues.get().getValue(index)) != null) {
            return cached;
        }
        ByteBuffer copyBuffer = this.cachedBuffer.get();
        if (index == 0) {
            startOffset = 4;
            endOffset = copyBuffer.getInt(this.indexOffset);
        } else {
            copyBuffer.position(this.indexOffset + (index - 1) * 4);
            startOffset = copyBuffer.getInt() + 4;
            endOffset = copyBuffer.getInt();
        }
        if (startOffset == endOffset) {
            return null;
        }
        copyBuffer.position(this.valuesOffset + startOffset);
        int size = endOffset - startOffset;
        T value = this.strategy.fromByteBuffer(copyBuffer, size);
        if (this.cacheable) {
            this.cachedValues.get().put(index, value, size);
        }
        return value;
    }

    @Override
    public int indexOf(T value) {
        if (!this.allowReverseLookup) {
            throw new UnsupportedOperationException("Reverse lookup not allowed.");
        }
        value = value != null && value.equals("") ? null : value;
        int minIndex = 0;
        int maxIndex = this.size - 1;
        while (minIndex <= maxIndex) {
            int currIndex = minIndex + maxIndex >>> 1;
            T currValue = this.get(currIndex);
            int comparison = this.strategy.compare(currValue, value);
            if (comparison == 0) {
                return currIndex;
            }
            if (comparison < 0) {
                minIndex = currIndex + 1;
                continue;
            }
            maxIndex = currIndex - 1;
        }
        return -(minIndex + 1);
    }

    public long getSerializedSize() {
        return this.theBuffer.remaining() + 2 + 4 + 4;
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{1, this.allowReverseLookup ? (byte)1 : 0}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)(this.theBuffer.remaining() + 4))));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.size)));
        channel.write(this.theBuffer.asReadOnlyBuffer());
    }

    public GenericIndexed<T> withCache(int maxBytes) {
        return new GenericIndexed<T>(this, maxBytes);
    }

    @Override
    public void close() throws IOException {
        if (this.cacheable) {
            log.debug("Closing column cache", new Object[0]);
            this.cachedValues.get().clear();
            this.cachedValues.remove();
        }
    }

    public static <T> GenericIndexed<T> read(ByteBuffer buffer, ObjectStrategy<T> strategy) {
        byte versionFromBuffer = buffer.get();
        if (1 == versionFromBuffer) {
            boolean allowReverseLookup = buffer.get() == 1;
            int size = buffer.getInt();
            ByteBuffer bufferToUse = buffer.asReadOnlyBuffer();
            bufferToUse.limit(bufferToUse.position() + size);
            buffer.position(bufferToUse.limit());
            return new GenericIndexed<T>(bufferToUse, strategy, allowReverseLookup);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }

    @Override
    public Iterator<T> iterator() {
        return IndexedIterable.create(this).iterator();
    }

    private static class SizedLRUMap<K, V>
    extends LinkedHashMap<K, Pair<Integer, V>> {
        private final int maxBytes;
        private int numBytes = 0;

        public SizedLRUMap(int initialCapacity, int maxBytes) {
            super(initialCapacity, 0.75f, true);
            this.maxBytes = maxBytes;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, Pair<Integer, V>> eldest) {
            if (this.numBytes > this.maxBytes) {
                this.numBytes -= ((Integer)eldest.getValue().lhs).intValue();
                return true;
            }
            return false;
        }

        public void put(K key, V value, int size) {
            int totalSize = size + 48;
            this.numBytes += totalSize;
            super.put(key, new Pair((Object)totalSize, value));
        }

        public V getValue(Object key) {
            Pair sizeValuePair = (Pair)super.get(key);
            return (V)(sizeValuePair == null ? null : sizeValuePair.rhs);
        }
    }
}

