/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.column;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.IAE;
import io.druid.segment.column.Column;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.column.ValueType;
import io.druid.segment.serde.ColumnPartSerde;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class ColumnDescriptor {
    private final ValueType valueType;
    private final boolean hasMultipleValues;
    private final List<ColumnPartSerde> parts;

    public static Builder builder() {
        return new Builder();
    }

    @JsonCreator
    public ColumnDescriptor(@JsonProperty(value="valueType") ValueType valueType, @JsonProperty(value="hasMultipleValues") boolean hasMultipleValues, @JsonProperty(value="parts") List<ColumnPartSerde> parts) {
        this.valueType = valueType;
        this.hasMultipleValues = hasMultipleValues;
        this.parts = parts;
    }

    @JsonProperty
    public ValueType getValueType() {
        return this.valueType;
    }

    @JsonProperty
    public boolean isHasMultipleValues() {
        return this.hasMultipleValues;
    }

    @JsonProperty
    public List<ColumnPartSerde> getParts() {
        return this.parts;
    }

    public long numBytes() {
        long retVal = 0L;
        for (ColumnPartSerde part : this.parts) {
            retVal += part.numBytes();
        }
        return retVal;
    }

    public void write(WritableByteChannel channel) throws IOException {
        for (ColumnPartSerde part : this.parts) {
            part.write(channel);
        }
    }

    public Column read(ByteBuffer buffer, ColumnConfig columnConfig) {
        ColumnBuilder builder = new ColumnBuilder().setType(this.valueType).setHasMultipleValues(this.hasMultipleValues);
        for (ColumnPartSerde part : this.parts) {
            part.read(buffer, builder, columnConfig);
        }
        return builder.build();
    }

    public static class Builder {
        private ValueType valueType = null;
        private Boolean hasMultipleValues = null;
        private final List<ColumnPartSerde> parts = Lists.newArrayList();

        public Builder setValueType(ValueType valueType) {
            if (this.valueType != null && this.valueType != valueType) {
                throw new IAE("valueType[%s] is already set, cannot change to[%s]", new Object[]{this.valueType, valueType});
            }
            this.valueType = valueType;
            return this;
        }

        public Builder setHasMultipleValues(boolean hasMultipleValues) {
            if (this.hasMultipleValues != null && this.hasMultipleValues != hasMultipleValues) {
                throw new IAE("hasMultipleValues[%s] is already set, cannot change to[%s]", new Object[]{this.hasMultipleValues, hasMultipleValues});
            }
            this.hasMultipleValues = hasMultipleValues;
            return this;
        }

        public Builder addSerde(ColumnPartSerde serde) {
            this.parts.add(serde);
            return this;
        }

        public ColumnDescriptor build() {
            Preconditions.checkNotNull((Object)((Object)this.valueType), (Object)"must specify a valueType");
            return new ColumnDescriptor(this.valueType, this.hasMultipleValues == null ? false : this.hasMultipleValues, this.parts);
        }
    }
}

