/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.Maps;
import com.metamx.common.guava.CloseQuietly;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.MMappedIndex;
import io.druid.segment.MetricHolder;
import io.druid.segment.Rowboat;
import io.druid.segment.data.ConciseCompressedIndexedInts;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedFloats;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedLongs;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.time.Interval;

public class MMappedIndexAdapter
implements IndexableAdapter {
    private final MMappedIndex index;
    private final int numRows;

    public MMappedIndexAdapter(MMappedIndex index) {
        this.index = index;
        this.numRows = index.getReadOnlyTimestamps().size();
    }

    @Override
    public Interval getDataInterval() {
        return this.index.getDataInterval();
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public Indexed<String> getAvailableDimensions() {
        return this.index.getAvailableDimensions();
    }

    @Override
    public Indexed<String> getAvailableMetrics() {
        return this.index.getAvailableMetrics();
    }

    @Override
    public Indexed<String> getDimValueLookup(String dimension) {
        return this.index.getDimValueLookup(dimension);
    }

    @Override
    public Iterable<Rowboat> getRows() {
        return new Iterable<Rowboat>(){

            @Override
            public Iterator<Rowboat> iterator() {
                return new Iterator<Rowboat>(){
                    final IndexedLongs timestamps;
                    final MetricHolder[] metrics;
                    final IndexedFloats[] floatMetrics;
                    final Map<String, Indexed<? extends IndexedInts>> dimensions;
                    final int numMetrics;
                    int currRow;
                    boolean done;
                    {
                        this.timestamps = MMappedIndexAdapter.this.index.getReadOnlyTimestamps();
                        this.numMetrics = MMappedIndexAdapter.this.index.getAvailableMetrics().size();
                        this.currRow = 0;
                        this.done = false;
                        this.dimensions = Maps.newLinkedHashMap();
                        for (String dim : MMappedIndexAdapter.this.index.getAvailableDimensions()) {
                            this.dimensions.put(dim, MMappedIndexAdapter.this.index.getDimColumn(dim));
                        }
                        GenericIndexed<String> availableMetrics = MMappedIndexAdapter.this.index.getAvailableMetrics();
                        this.metrics = new MetricHolder[availableMetrics.size()];
                        this.floatMetrics = new IndexedFloats[availableMetrics.size()];
                        for (int i = 0; i < this.metrics.length; ++i) {
                            this.metrics[i] = MMappedIndexAdapter.this.index.getMetricHolder((String)availableMetrics.get(i));
                            if (this.metrics[i].getType() != MetricHolder.MetricType.FLOAT) continue;
                            this.floatMetrics[i] = this.metrics[i].getFloatType();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        boolean hasNext;
                        boolean bl = hasNext = this.currRow < MMappedIndexAdapter.this.numRows;
                        if (!hasNext && !this.done) {
                            CloseQuietly.close((Closeable)this.timestamps);
                            for (IndexedFloats floatMetric : this.floatMetrics) {
                                CloseQuietly.close((Closeable)floatMetric);
                            }
                            this.done = true;
                        }
                        return hasNext;
                    }

                    @Override
                    public Rowboat next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int[][] dims = new int[this.dimensions.size()][];
                        int dimIndex = 0;
                        for (String dim : this.dimensions.keySet()) {
                            IndexedInts dimVals = this.dimensions.get(dim).get(this.currRow);
                            int[] theVals = new int[dimVals.size()];
                            for (int j = 0; j < theVals.length; ++j) {
                                theVals[j] = dimVals.get(j);
                            }
                            dims[dimIndex++] = theVals;
                        }
                        Object[] metricArray = new Object[this.numMetrics];
                        block6: for (int i = 0; i < metricArray.length; ++i) {
                            switch (this.metrics[i].getType()) {
                                case FLOAT: {
                                    metricArray[i] = Float.valueOf(this.floatMetrics[i].get(this.currRow));
                                    continue block6;
                                }
                                case COMPLEX: {
                                    metricArray[i] = this.metrics[i].getComplexType().get(this.currRow);
                                }
                            }
                        }
                        HashMap descriptions = Maps.newHashMap();
                        for (String spatialDim : MMappedIndexAdapter.this.index.getSpatialIndexes().keySet()) {
                            descriptions.put(spatialDim, "spatial");
                        }
                        Rowboat retVal = new Rowboat(this.timestamps.get(this.currRow), dims, metricArray, this.currRow, descriptions);
                        ++this.currRow;
                        return retVal;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public IndexedInts getInverteds(String dimension, String value) {
        return new ConciseCompressedIndexedInts(this.index.getInvertedIndex(dimension, value));
    }

    @Override
    public String getMetricType(String metric) {
        MetricHolder holder = this.index.getMetricHolder(metric);
        if (holder == null) {
            return null;
        }
        return holder.getTypeName();
    }
}

