/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.collect.Maps;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.io.smoosh.SmooshedFileMapper;
import com.metamx.common.logger.Logger;
import io.druid.segment.MetricHolder;
import io.druid.segment.data.CompressedLongsIndexedSupplier;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedLongs;
import io.druid.segment.data.VSizeIndexed;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.io.IOException;
import java.util.Map;
import org.joda.time.Interval;

public class MMappedIndex {
    private static final Logger log = new Logger(MMappedIndex.class);
    private static final ImmutableConciseSet emptySet = new ImmutableConciseSet();
    final GenericIndexed<String> availableDimensions;
    final GenericIndexed<String> availableMetrics;
    final Interval dataInterval;
    final CompressedLongsIndexedSupplier timestamps;
    final Map<String, MetricHolder> metrics;
    final Map<String, GenericIndexed<String>> dimValueLookups;
    final Map<String, VSizeIndexed> dimColumns;
    final Map<String, GenericIndexed<ImmutableConciseSet>> invertedIndexes;
    final Map<String, ImmutableRTree> spatialIndexes;
    final SmooshedFileMapper fileMapper;
    private final Map<String, Integer> metricIndexes = Maps.newHashMap();

    public MMappedIndex(GenericIndexed<String> availableDimensions, GenericIndexed<String> availableMetrics, Interval dataInterval, CompressedLongsIndexedSupplier timestamps, Map<String, MetricHolder> metrics, Map<String, GenericIndexed<String>> dimValueLookups, Map<String, VSizeIndexed> dimColumns, Map<String, GenericIndexed<ImmutableConciseSet>> invertedIndexes, Map<String, ImmutableRTree> spatialIndexes, SmooshedFileMapper fileMapper) {
        this.availableDimensions = availableDimensions;
        this.availableMetrics = availableMetrics;
        this.dataInterval = dataInterval;
        this.timestamps = timestamps;
        this.metrics = metrics;
        this.dimValueLookups = dimValueLookups;
        this.dimColumns = dimColumns;
        this.invertedIndexes = invertedIndexes;
        this.spatialIndexes = spatialIndexes;
        this.fileMapper = fileMapper;
        for (int i = 0; i < availableMetrics.size(); ++i) {
            this.metricIndexes.put(availableMetrics.get(i), i);
        }
    }

    public CompressedLongsIndexedSupplier getTimestamps() {
        return this.timestamps;
    }

    public GenericIndexed<String> getAvailableDimensions() {
        return this.availableDimensions;
    }

    public GenericIndexed<String> getAvailableMetrics() {
        return this.availableMetrics;
    }

    public Map<String, MetricHolder> getMetrics() {
        return this.metrics;
    }

    public Integer getMetricIndex(String metricName) {
        return this.metricIndexes.get(metricName);
    }

    public Interval getDataInterval() {
        return this.dataInterval;
    }

    public IndexedLongs getReadOnlyTimestamps() {
        return this.timestamps.get();
    }

    public MetricHolder getMetricHolder(String metric) {
        MetricHolder retVal = this.metrics.get(metric);
        if (retVal == null) {
            return null;
        }
        return retVal;
    }

    public GenericIndexed<String> getDimValueLookup(String dimension) {
        return this.dimValueLookups.get(dimension);
    }

    public VSizeIndexed getDimColumn(String dimension) {
        return this.dimColumns.get(dimension);
    }

    public Map<String, GenericIndexed<ImmutableConciseSet>> getInvertedIndexes() {
        return this.invertedIndexes;
    }

    public Map<String, ImmutableRTree> getSpatialIndexes() {
        return this.spatialIndexes;
    }

    public ImmutableConciseSet getInvertedIndex(String dimension, String value) {
        GenericIndexed<String> lookup = this.dimValueLookups.get(dimension);
        if (lookup == null) {
            return emptySet;
        }
        int indexOf = lookup.indexOf(value);
        if (indexOf < 0) {
            return emptySet;
        }
        ImmutableConciseSet retVal = this.invertedIndexes.get(dimension).get(indexOf);
        return retVal == null ? emptySet : retVal;
    }

    public SmooshedFileMapper getFileMapper() {
        return this.fileMapper;
    }

    public void close() throws IOException {
        if (this.fileMapper != null) {
            this.fileMapper.close();
        }
    }
}

