/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Supplier;
import com.metamx.common.logger.Logger;
import com.ning.compress.lzf.ChunkEncoder;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;

public class CompressedPools {
    private static final Logger log = new Logger(CompressedPools.class);
    private static final StupidPool<ChunkEncoder> chunkEncoderPool = new StupidPool((Supplier)new Supplier<ChunkEncoder>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public ChunkEncoder get() {
            log.info("Allocating new chunkEncoder[%,d]", new Object[]{this.counter.incrementAndGet()});
            return new ChunkEncoder(65535);
        }
    });
    private static final StupidPool<byte[]> outputBytesPool = new StupidPool((Supplier)new Supplier<byte[]>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public byte[] get() {
            log.info("Allocating new outputBytesPool[%,d]", new Object[]{this.counter.incrementAndGet()});
            return new byte[65535];
        }
    });
    private static final StupidPool<ByteBuffer> bigEndByteBufPool = new StupidPool((Supplier)new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public ByteBuffer get() {
            log.info("Allocating new bigEndByteBuf[%,d]", new Object[]{this.counter.incrementAndGet()});
            return ByteBuffer.allocateDirect(65535).order(ByteOrder.BIG_ENDIAN);
        }
    });
    private static final StupidPool<ByteBuffer> littleEndByteBufPool = new StupidPool((Supplier)new Supplier<ByteBuffer>(){
        private final AtomicLong counter = new AtomicLong(0L);

        public ByteBuffer get() {
            log.info("Allocating new littleEndByteBuf[%,d]", new Object[]{this.counter.incrementAndGet()});
            return ByteBuffer.allocateDirect(65535).order(ByteOrder.LITTLE_ENDIAN);
        }
    });

    public static ResourceHolder<ChunkEncoder> getChunkEncoder() {
        return chunkEncoderPool.take();
    }

    public static ResourceHolder<byte[]> getOutputBytes() {
        return outputBytesPool.take();
    }

    public static ResourceHolder<ByteBuffer> getByteBuf(ByteOrder order) {
        if (order == ByteOrder.LITTLE_ENDIAN) {
            return littleEndByteBufPool.take();
        }
        return bigEndByteBufPool.take();
    }
}

