/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.common.guava.CloseQuietly;
import io.druid.query.filter.BitmapIndexSelector;
import io.druid.segment.ColumnSelector;
import io.druid.segment.column.Column;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.GenericColumn;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedIterable;
import it.uniroma3.mat.extendedset.intset.ImmutableConciseSet;
import java.io.Closeable;
import java.util.Iterator;

public class ColumnSelectorBitmapIndexSelector
implements BitmapIndexSelector {
    private final ColumnSelector index;

    public ColumnSelectorBitmapIndexSelector(ColumnSelector index) {
        this.index = index;
    }

    @Override
    public Indexed<String> getDimensionValues(String dimension) {
        Column columnDesc = this.index.getColumn(dimension.toLowerCase());
        if (columnDesc == null || !columnDesc.getCapabilities().isDictionaryEncoded()) {
            return null;
        }
        final DictionaryEncodedColumn column = columnDesc.getDictionaryEncoding();
        return new Indexed<String>(){

            @Override
            public Class<? extends String> getClazz() {
                return String.class;
            }

            @Override
            public int size() {
                return column.getCardinality();
            }

            @Override
            public String get(int index) {
                return column.lookupName(index);
            }

            @Override
            public int indexOf(String value) {
                return column.lookupId(value);
            }

            @Override
            public Iterator<String> iterator() {
                return IndexedIterable.create(this).iterator();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumRows() {
        int n;
        GenericColumn column = null;
        try {
            column = this.index.getTimeColumn().getGenericColumn();
            n = column.length();
        }
        catch (Throwable throwable) {
            CloseQuietly.close(column);
            throw throwable;
        }
        CloseQuietly.close((Closeable)column);
        return n;
    }

    @Override
    public ImmutableConciseSet getConciseInvertedIndex(String dimension, String value) {
        Column column = this.index.getColumn(dimension.toLowerCase());
        if (column == null) {
            return new ImmutableConciseSet();
        }
        if (!column.getCapabilities().hasBitmapIndexes()) {
            return new ImmutableConciseSet();
        }
        return column.getBitmapIndex().getConciseSet(value);
    }

    @Override
    public ImmutableConciseSet getConciseInvertedIndex(String dimension, int idx) {
        Column column = this.index.getColumn(dimension.toLowerCase());
        if (column == null) {
            return new ImmutableConciseSet();
        }
        if (!column.getCapabilities().hasBitmapIndexes()) {
            return new ImmutableConciseSet();
        }
        int index1 = column.getBitmapIndex().hasNulls() ? idx + 1 : idx;
        return column.getBitmapIndex().getConciseSet(index1);
    }

    @Override
    public ImmutableRTree getSpatialIndex(String dimension) {
        Column column = this.index.getColumn(dimension.toLowerCase());
        if (column == null || !column.getCapabilities().hasSpatialIndexes()) {
            return new ImmutableRTree();
        }
        return column.getSpatialIndex().getRTree();
    }
}

