/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.granularity.QueryGranularity;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSourceUtil;
import io.druid.query.IntervalChunkingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryCacheHelper;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.ResultGranularTimestampComparator;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorUtil;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.filter.DimFilter;
import io.druid.query.topn.BySegmentTopNResultValue;
import io.druid.query.topn.DimensionAndMetricValueExtractor;
import io.druid.query.topn.TopNBinaryFn;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNQueryConfig;
import io.druid.query.topn.TopNResultMerger;
import io.druid.query.topn.TopNResultValue;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInterval;

public class TopNQueryQueryToolChest
extends QueryToolChest<Result<TopNResultValue>, TopNQuery> {
    private static final byte TOPN_QUERY = 1;
    private static final Joiner COMMA_JOIN = Joiner.on((String)",");
    private static final TypeReference<Result<TopNResultValue>> TYPE_REFERENCE = new TypeReference<Result<TopNResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private final TopNQueryConfig config;

    @Inject
    public TopNQueryQueryToolChest(TopNQueryConfig config) {
        this.config = config;
    }

    private static List<PostAggregator> prunePostAggregators(TopNQuery query) {
        return AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> mergeResults(QueryRunner<Result<TopNResultValue>> runner) {
        return new ResultMergeQueryRunner<Result<TopNResultValue>>(runner){

            @Override
            protected Ordering<Result<TopNResultValue>> makeOrdering(Query<Result<TopNResultValue>> query) {
                return Ordering.from(new ResultGranularTimestampComparator(((TopNQuery)query).getGranularity()));
            }

            @Override
            protected BinaryFn<Result<TopNResultValue>, Result<TopNResultValue>, Result<TopNResultValue>> createMergeFn(Query<Result<TopNResultValue>> input) {
                TopNQuery query = (TopNQuery)input;
                return new TopNBinaryFn(TopNResultMerger.identity, query.getGranularity(), query.getDimensionSpec(), query.getTopNMetricSpec(), query.getThreshold(), query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
            }
        };
    }

    @Override
    public Sequence<Result<TopNResultValue>> mergeSequences(Sequence<Sequence<Result<TopNResultValue>>> seqOfSequences) {
        return new OrderedMergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(TopNQuery query) {
        int numMinutes = 0;
        for (Interval interval : query.getIntervals()) {
            numMinutes += Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }
        return new ServiceMetricEvent.Builder().setUser2(DataSourceUtil.getMetricName(query.getDataSource())).setUser4(String.format("topN/%s/%s", query.getThreshold(), query.getDimensionSpec().getDimension())).setUser5(COMMA_JOIN.join(query.getIntervals())).setUser6(String.valueOf(query.hasFilters())).setUser7(String.format("%,d aggs", query.getAggregatorSpecs().size())).setUser9(Minutes.minutes((int)numMinutes).toString());
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePreComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
            }

            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList serializedValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)result.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap values = Maps.newHashMap();
                        for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                            values.put(agg.getName(), fn.manipulate(agg, input.getMetric(agg.getName())));
                        }
                        for (PostAggregator postAgg : TopNQueryQueryToolChest.prunePostAggregators(query)) {
                            Object calculatedPostAgg = input.getMetric(postAgg.getName());
                            if (calculatedPostAgg != null) {
                                values.put(postAgg.getName(), calculatedPostAgg);
                                continue;
                            }
                            values.put(postAgg.getName(), postAgg.compute(values));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public Function<Result<TopNResultValue>, Result<TopNResultValue>> makePostComputeManipulatorFn(final TopNQuery query, final MetricManipulationFn fn) {
        return new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){
            private String dimension;
            {
                this.dimension = query.getDimensionSpec().getOutputName();
            }

            public Result<TopNResultValue> apply(Result<TopNResultValue> result) {
                ArrayList serializedValues = Lists.newArrayList((Iterable)Iterables.transform((Iterable)result.getValue(), (Function)new Function<DimensionAndMetricValueExtractor, Map<String, Object>>(){

                    public Map<String, Object> apply(DimensionAndMetricValueExtractor input) {
                        HashMap values = Maps.newHashMap();
                        for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                            values.put(agg.getName(), input.getMetric(agg.getName()));
                        }
                        for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                            Object calculatedPostAgg = input.getMetric(postAgg.getName());
                            if (calculatedPostAgg != null) {
                                values.put(postAgg.getName(), calculatedPostAgg);
                                continue;
                            }
                            values.put(postAgg.getName(), postAgg.compute(values));
                        }
                        for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                            values.put(agg.getName(), fn.manipulate(agg, input.getMetric(agg.getName())));
                        }
                        values.put(dimension, input.getDimensionValue(dimension));
                        return values;
                    }
                }));
                return new Result<TopNResultValue>(result.getTimestamp(), new TopNResultValue(serializedValues));
            }
        };
    }

    @Override
    public TypeReference<Result<TopNResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TopNResultValue>, Object, TopNQuery> getCacheStrategy(final TopNQuery query) {
        return new CacheStrategy<Result<TopNResultValue>, Object, TopNQuery>(){
            private final List<AggregatorFactory> aggs;
            private final List<PostAggregator> postAggs;
            {
                this.aggs = query.getAggregatorSpecs();
                this.postAggs = AggregatorUtil.pruneDependentPostAgg(query.getPostAggregatorSpecs(), query.getTopNMetricSpec().getMetricName(query.getDimensionSpec()));
            }

            @Override
            public byte[] computeCacheKey(TopNQuery query2) {
                byte[] dimensionSpecBytes = query2.getDimensionSpec().getCacheKey();
                byte[] metricSpecBytes = query2.getTopNMetricSpec().getCacheKey();
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] aggregatorBytes = QueryCacheHelper.computeAggregatorBytes(query2.getAggregatorSpecs());
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                return ByteBuffer.allocate(1 + dimensionSpecBytes.length + metricSpecBytes.length + 4 + granularityBytes.length + filterBytes.length + aggregatorBytes.length).put((byte)1).put(dimensionSpecBytes).put(metricSpecBytes).put(Ints.toByteArray((int)query2.getThreshold())).put(granularityBytes).put(filterBytes).put(aggregatorBytes).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TopNResultValue>, Object> prepareForCache() {
                return new Function<Result<TopNResultValue>, Object>(){

                    public Object apply(Result<TopNResultValue> input) {
                        ArrayList results = Lists.newArrayList((Iterable)input.getValue());
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)(results.size() + 1));
                        retVal.add(input.getTimestamp().getMillis());
                        for (DimensionAndMetricValueExtractor result : results) {
                            ArrayList vals = Lists.newArrayListWithCapacity((int)(aggs.size() + 2));
                            vals.add(result.getStringDimensionValue(query.getDimensionSpec().getOutputName()));
                            for (AggregatorFactory agg : aggs) {
                                vals.add(result.getMetric(agg.getName()));
                            }
                            retVal.add(vals);
                        }
                        return retVal;
                    }
                };
            }

            @Override
            public Function<Object, Result<TopNResultValue>> pullFromCache() {
                return new Function<Object, Result<TopNResultValue>>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Result<TopNResultValue> apply(Object input) {
                        List results = (List)input;
                        ArrayList retVal = Lists.newArrayListWithCapacity((int)results.size());
                        Iterator inputIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(new DateTime(inputIter.next()).getMillis());
                        while (inputIter.hasNext()) {
                            List result = (List)inputIter.next();
                            LinkedHashMap vals = Maps.newLinkedHashMap();
                            Iterator aggIter = aggs.iterator();
                            Iterator resultIter = result.iterator();
                            vals.put(query.getDimensionSpec().getOutputName(), resultIter.next());
                            while (aggIter.hasNext() && resultIter.hasNext()) {
                                AggregatorFactory factory = (AggregatorFactory)aggIter.next();
                                vals.put(factory.getName(), factory.deserialize(resultIter.next()));
                            }
                            for (PostAggregator postAgg : postAggs) {
                                vals.put(postAgg.getName(), postAgg.compute(vals));
                            }
                            retVal.add(vals);
                        }
                        return new Result<TopNResultValue>(timestamp, new TopNResultValue(retVal));
                    }
                };
            }

            @Override
            public Sequence<Result<TopNResultValue>> mergeSequences(Sequence<Sequence<Result<TopNResultValue>>> seqOfSequences) {
                return new MergeSequence(TopNQueryQueryToolChest.this.getOrdering(), seqOfSequences);
            }
        };
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> preMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        return new IntervalChunkingQueryRunner<Result<TopNResultValue>>(runner, this.config.getChunkPeriod());
    }

    @Override
    public QueryRunner<Result<TopNResultValue>> postMergeQueryDecoration(QueryRunner<Result<TopNResultValue>> runner) {
        return new ThresholdAdjustingQueryRunner(runner, this.config.getMinTopNThreshold());
    }

    public Ordering<Result<TopNResultValue>> getOrdering() {
        return Ordering.natural();
    }

    private static class ThresholdAdjustingQueryRunner
    implements QueryRunner<Result<TopNResultValue>> {
        private final QueryRunner<Result<TopNResultValue>> runner;
        private final int minTopNThreshold;

        public ThresholdAdjustingQueryRunner(QueryRunner<Result<TopNResultValue>> runner, int minTopNThreshold) {
            this.runner = runner;
            this.minTopNThreshold = minTopNThreshold;
        }

        @Override
        public Sequence<Result<TopNResultValue>> run(Query<Result<TopNResultValue>> input) {
            if (!(input instanceof TopNQuery)) {
                throw new ISE("Can only handle [%s], got [%s]", new Object[]{TopNQuery.class, input.getClass()});
            }
            final TopNQuery query = (TopNQuery)input;
            if (query.getThreshold() > this.minTopNThreshold) {
                return this.runner.run(query);
            }
            final boolean isBySegment = query.getContextBySegment(false);
            return Sequences.map(this.runner.run(query.withThreshold(this.minTopNThreshold)), (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                    if (isBySegment) {
                        BySegmentTopNResultValue value = (BySegmentTopNResultValue)input.getValue();
                        return new Result<TopNResultValue>(input.getTimestamp(), new BySegmentTopNResultValue(Lists.transform(value.getResults(), (Function)new Function<Result<TopNResultValue>, Result<TopNResultValue>>(){

                            public Result<TopNResultValue> apply(Result<TopNResultValue> input) {
                                return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                            }
                        }), value.getSegmentId(), value.getIntervalString()));
                    }
                    return new Result<TopNResultValue>(input.getTimestamp(), new TopNResultValue(Lists.newArrayList((Iterable)Iterables.limit((Iterable)input.getValue(), (int)query.getThreshold()))));
                }
            });
        }
    }
}

