/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.collect.Lists;
import io.druid.granularity.QueryGranularity;
import io.druid.query.DataSource;
import io.druid.query.TableDataSource;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.topn.NumericTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpec;
import io.druid.query.topn.TopNQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.Interval;

public class TopNQueryBuilder {
    private DataSource dataSource = null;
    private DimensionSpec dimensionSpec = null;
    private TopNMetricSpec topNMetricSpec = null;
    private int threshold = 0;
    private QuerySegmentSpec querySegmentSpec = null;
    private DimFilter dimFilter = null;
    private QueryGranularity granularity = QueryGranularity.ALL;
    private List<AggregatorFactory> aggregatorSpecs = Lists.newArrayList();
    private List<PostAggregator> postAggregatorSpecs = Lists.newArrayList();
    private Map<String, Object> context = null;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DimensionSpec getDimensionSpec() {
        return this.dimensionSpec;
    }

    public TopNMetricSpec getTopNMetricSpec() {
        return this.topNMetricSpec;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public QuerySegmentSpec getQuerySegmentSpec() {
        return this.querySegmentSpec;
    }

    public DimFilter getDimFilter() {
        return this.dimFilter;
    }

    public QueryGranularity getGranularity() {
        return this.granularity;
    }

    public List<AggregatorFactory> getAggregatorSpecs() {
        return this.aggregatorSpecs;
    }

    public List<PostAggregator> getPostAggregatorSpecs() {
        return this.postAggregatorSpecs;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public TopNQuery build() {
        return new TopNQuery(this.dataSource, this.dimensionSpec, this.topNMetricSpec, this.threshold, this.querySegmentSpec, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.context);
    }

    public TopNQueryBuilder copy(TopNQuery query) {
        return new TopNQueryBuilder().dataSource(query.getDataSource().toString()).dimension(query.getDimensionSpec()).metric(query.getTopNMetricSpec()).threshold(query.getThreshold()).intervals(query.getIntervals()).filters(query.getDimensionsFilter()).granularity(query.getGranularity()).aggregators(query.getAggregatorSpecs()).postAggregators(query.getPostAggregatorSpecs()).context(query.getContext());
    }

    public TopNQueryBuilder copy(TopNQueryBuilder builder) {
        return new TopNQueryBuilder().dataSource(builder.dataSource).dimension(builder.dimensionSpec).metric(builder.topNMetricSpec).threshold(builder.threshold).intervals(builder.querySegmentSpec).filters(builder.dimFilter).granularity(builder.granularity).aggregators(builder.aggregatorSpecs).postAggregators(builder.postAggregatorSpecs).context(builder.context);
    }

    public TopNQueryBuilder dataSource(String d) {
        this.dataSource = new TableDataSource(d);
        return this;
    }

    public TopNQueryBuilder dataSource(DataSource d) {
        this.dataSource = d;
        return this;
    }

    public TopNQueryBuilder dimension(String d) {
        return this.dimension(d, null);
    }

    public TopNQueryBuilder dimension(String d, String outputName) {
        return this.dimension(new DefaultDimensionSpec(d, outputName));
    }

    public TopNQueryBuilder dimension(DimensionSpec d) {
        this.dimensionSpec = d;
        return this;
    }

    public TopNQueryBuilder metric(String s) {
        return this.metric(new NumericTopNMetricSpec(s));
    }

    public TopNQueryBuilder metric(TopNMetricSpec t) {
        this.topNMetricSpec = t;
        return this;
    }

    public TopNQueryBuilder threshold(int i) {
        this.threshold = i;
        return this;
    }

    public TopNQueryBuilder intervals(QuerySegmentSpec q) {
        this.querySegmentSpec = q;
        return this;
    }

    public TopNQueryBuilder intervals(String s) {
        this.querySegmentSpec = new LegacySegmentSpec(s);
        return this;
    }

    public TopNQueryBuilder intervals(List<Interval> l) {
        this.querySegmentSpec = new LegacySegmentSpec((Object)l);
        return this;
    }

    public TopNQueryBuilder filters(String dimensionName, String value) {
        this.dimFilter = new SelectorDimFilter(dimensionName, value);
        return this;
    }

    public TopNQueryBuilder filters(String dimensionName, String value, String ... values) {
        ArrayList fields = Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter(dimensionName, value)});
        for (String val : values) {
            fields.add(new SelectorDimFilter(dimensionName, val));
        }
        this.dimFilter = new OrDimFilter(fields);
        return this;
    }

    public TopNQueryBuilder filters(DimFilter f) {
        this.dimFilter = f;
        return this;
    }

    public TopNQueryBuilder granularity(String g) {
        this.granularity = QueryGranularity.fromString(g);
        return this;
    }

    public TopNQueryBuilder granularity(QueryGranularity g) {
        this.granularity = g;
        return this;
    }

    public TopNQueryBuilder aggregators(List<AggregatorFactory> a) {
        this.aggregatorSpecs = a;
        return this;
    }

    public TopNQueryBuilder postAggregators(List<PostAggregator> p) {
        this.postAggregatorSpecs = p;
        return this;
    }

    public TopNQueryBuilder context(Map<String, Object> c) {
        this.context = c;
        return this;
    }
}

