/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import io.druid.query.Result;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorUtil;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.topn.DimValHolder;
import io.druid.query.topn.DimensionAndMetricValueExtractor;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.query.topn.TopNResultValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class TopNNumericResultBuilder
implements TopNResultBuilder {
    private final DateTime timestamp;
    private final DimensionSpec dimSpec;
    private final String metricName;
    private final List<AggregatorFactory> aggFactories;
    private final List<PostAggregator> postAggs;
    private MinMaxPriorityQueue<DimValHolder> pQueue = null;

    public TopNNumericResultBuilder(DateTime timestamp, DimensionSpec dimSpec, String metricName, int threshold, Comparator comparator, List<AggregatorFactory> aggFactories, List<PostAggregator> postAggs) {
        this.timestamp = timestamp;
        this.dimSpec = dimSpec;
        this.metricName = metricName;
        this.aggFactories = aggFactories;
        this.postAggs = AggregatorUtil.pruneDependentPostAgg(postAggs, this.metricName);
        this.instantiatePQueue(threshold, comparator);
    }

    @Override
    public TopNResultBuilder addEntry(String dimName, Object dimValIndex, Object[] metricVals) {
        LinkedHashMap metricValues = Maps.newLinkedHashMap();
        metricValues.put(this.dimSpec.getOutputName(), dimName);
        Iterator<AggregatorFactory> aggFactoryIter = this.aggFactories.iterator();
        for (Object metricVal : metricVals) {
            metricValues.put(aggFactoryIter.next().getName(), metricVal);
        }
        for (PostAggregator postAgg : this.postAggs) {
            metricValues.put(postAgg.getName(), postAgg.compute(metricValues));
        }
        Object topNMetricVal = metricValues.get(this.metricName);
        this.pQueue.add((Object)new DimValHolder.Builder().withTopNMetricVal(topNMetricVal).withDirName(dimName).withDimValIndex(dimValIndex).withMetricValues(metricValues).build());
        return this;
    }

    @Override
    public TopNResultBuilder addEntry(DimensionAndMetricValueExtractor dimensionAndMetricValueExtractor) {
        this.pQueue.add((Object)new DimValHolder.Builder().withTopNMetricVal(dimensionAndMetricValueExtractor.getDimensionValue(this.metricName)).withDirName(this.dimSpec.getOutputName()).withMetricValues(dimensionAndMetricValueExtractor.getBaseObject()).build());
        return this;
    }

    @Override
    public Iterator<DimValHolder> getTopNIterator() {
        return this.pQueue.iterator();
    }

    @Override
    public Result<TopNResultValue> build() {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>(this.pQueue.size());
        while (!this.pQueue.isEmpty()) {
            values.add(((DimValHolder)this.pQueue.remove()).getMetricValues());
        }
        return new Result<TopNResultValue>(this.timestamp, new TopNResultValue(values));
    }

    private void instantiatePQueue(int threshold, final Comparator comparator) {
        this.pQueue = MinMaxPriorityQueue.orderedBy((Comparator)new Comparator<DimValHolder>(){

            @Override
            public int compare(DimValHolder d1, DimValHolder d2) {
                int retVal = comparator.compare(d2.getTopNMetricVal(), d1.getTopNMetricVal());
                if (retVal == 0) {
                    retVal = d1.getDimName() == null ? -1 : (d2.getDimName() == null ? 1 : d1.getDimName().compareTo(d2.getDimName()));
                }
                return retVal;
            }
        }).maximumSize(threshold).create();
    }
}

