/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.google.common.collect.Maps;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.topn.BaseTopNAlgorithm;
import io.druid.query.topn.TopNParams;
import io.druid.query.topn.TopNQuery;
import io.druid.query.topn.TopNResultBuilder;
import io.druid.segment.Capabilities;
import io.druid.segment.Cursor;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import java.util.Map;

public class DimExtractionTopNAlgorithm
extends BaseTopNAlgorithm<Aggregator[][], Map<String, Aggregator[]>, TopNParams> {
    private final TopNQuery query;

    public DimExtractionTopNAlgorithm(Capabilities capabilities, TopNQuery query) {
        super(capabilities);
        this.query = query;
    }

    @Override
    public TopNParams makeInitParams(DimensionSelector dimSelector, Cursor cursor) {
        return new TopNParams(dimSelector, cursor, dimSelector.getValueCardinality(), Integer.MAX_VALUE);
    }

    @Override
    protected Aggregator[][] makeDimValSelector(TopNParams params, int numProcessed, int numToProcess) {
        BaseTopNAlgorithm.AggregatorArrayProvider provider = new BaseTopNAlgorithm.AggregatorArrayProvider(params.getDimSelector(), this.query, params.getCardinality());
        if (!this.query.getDimensionSpec().preservesOrdering()) {
            return provider.build();
        }
        return this.query.getTopNMetricSpec().configureOptimizer(provider).build();
    }

    @Override
    protected Aggregator[][] updateDimValSelector(Aggregator[][] aggregators, int numProcessed, int numToProcess) {
        return aggregators;
    }

    @Override
    protected Map<String, Aggregator[]> makeDimValAggregateStore(TopNParams params) {
        return Maps.newHashMap();
    }

    @Override
    public void scanAndAggregate(TopNParams params, Aggregator[][] rowSelector, Map<String, Aggregator[]> aggregatesStore, int numProcessed) {
        Cursor cursor = params.getCursor();
        DimensionSelector dimSelector = params.getDimSelector();
        while (!cursor.isDone()) {
            IndexedInts dimValues = dimSelector.getRow();
            for (int i = 0; i < dimValues.size(); ++i) {
                int dimIndex = dimValues.get(i);
                Aggregator[] theAggregators = rowSelector[dimIndex];
                if (theAggregators == null) {
                    String key = this.query.getDimensionSpec().getDimExtractionFn().apply(dimSelector.lookupName(dimIndex));
                    if (key == null) {
                        rowSelector[dimIndex] = EMPTY_ARRAY;
                        continue;
                    }
                    theAggregators = aggregatesStore.get(key);
                    if (theAggregators == null) {
                        theAggregators = DimExtractionTopNAlgorithm.makeAggregators(cursor, this.query.getAggregatorSpecs());
                        aggregatesStore.put(key, theAggregators);
                    }
                    rowSelector[dimIndex] = theAggregators;
                }
                for (Aggregator aggregator : theAggregators) {
                    aggregator.aggregate();
                }
            }
            cursor.advance();
        }
    }

    @Override
    protected void updateResults(TopNParams params, Aggregator[][] rowSelector, Map<String, Aggregator[]> aggregatesStore, TopNResultBuilder resultBuilder) {
        for (Map.Entry<String, Aggregator[]> entry : aggregatesStore.entrySet()) {
            Aggregator[] aggs = entry.getValue();
            if (aggs == null || aggs.length <= 0) continue;
            Object[] vals = new Object[aggs.length];
            for (int i = 0; i < aggs.length; ++i) {
                vals[i] = aggs[i].get();
            }
            resultBuilder.addEntry(entry.getKey(), entry.getKey(), vals);
        }
    }

    @Override
    protected void closeAggregators(Map<String, Aggregator[]> stringMap) {
        for (Aggregator[] aggregators : stringMap.values()) {
            for (Aggregator agg : aggregators) {
                agg.close();
            }
        }
    }

    @Override
    public void cleanup(TopNParams params) {
    }
}

