/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.topn;

import com.davekoelle.alphanum.AlphanumComparator;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Charsets;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.topn.LexicographicTopNMetricSpec;
import io.druid.query.topn.TopNMetricSpecBuilder;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;

public class AlphaNumericTopNMetricSpec
extends LexicographicTopNMetricSpec {
    private static final byte CACHE_TYPE_ID = 2;
    private final String previousStop;

    @JsonCreator
    public AlphaNumericTopNMetricSpec(@JsonProperty(value="previousStop") String previousStop) {
        super(previousStop);
        this.previousStop = previousStop == null ? "" : previousStop;
    }

    @Override
    public Comparator getComparator(List<AggregatorFactory> aggregatorSpecs, List<PostAggregator> postAggregatorSpecs) {
        return new AlphanumComparator();
    }

    @Override
    public byte[] getCacheKey() {
        byte[] previousStopBytes = this.previousStop.getBytes(Charsets.UTF_8);
        return ByteBuffer.allocate(1 + previousStopBytes.length).put((byte)2).put(previousStopBytes).array();
    }

    @Override
    public <T> TopNMetricSpecBuilder<T> configureOptimizer(TopNMetricSpecBuilder<T> builder) {
        return builder;
    }

    @Override
    public String toString() {
        return "AlphaNumericTopNMetricSpec{previousStop='" + this.previousStop + '\'' + '}';
    }
}

