/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.timeboundary;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.query.BySegmentSkippingQueryRunner;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSourceUtil;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.Result;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.timeline.LogicalSegment;
import java.nio.ByteBuffer;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInterval;

public class TimeBoundaryQueryQueryToolChest
extends QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final byte TIMEBOUNDARY_QUERY = 3;
    private static final TypeReference<Result<TimeBoundaryResultValue>> TYPE_REFERENCE = new TypeReference<Result<TimeBoundaryResultValue>>(){};
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(TimeBoundaryQuery query, List<T> segments) {
        if (segments.size() <= 1) {
            return segments;
        }
        final LogicalSegment min = (LogicalSegment)segments.get(0);
        final LogicalSegment max = (LogicalSegment)segments.get(segments.size() - 1);
        return Lists.newArrayList((Iterable)Iterables.filter(segments, (Predicate)new Predicate<T>(){

            public boolean apply(T input) {
                return min != null && input.getInterval().overlaps((ReadableInterval)min.getInterval()) || max != null && input.getInterval().overlaps((ReadableInterval)max.getInterval());
            }
        }));
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeResults(QueryRunner<Result<TimeBoundaryResultValue>> runner) {
        return new BySegmentSkippingQueryRunner<Result<TimeBoundaryResultValue>>(runner){

            @Override
            protected Sequence<Result<TimeBoundaryResultValue>> doRun(QueryRunner<Result<TimeBoundaryResultValue>> baseRunner, Query<Result<TimeBoundaryResultValue>> input) {
                TimeBoundaryQuery query = (TimeBoundaryQuery)input;
                return Sequences.simple(query.mergeResults(Sequences.toList(baseRunner.run(query), (List)Lists.newArrayList())));
            }
        };
    }

    @Override
    public Sequence<Result<TimeBoundaryResultValue>> mergeSequences(Sequence<Sequence<Result<TimeBoundaryResultValue>>> seqOfSequences) {
        return new OrderedMergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(TimeBoundaryQuery query) {
        return new ServiceMetricEvent.Builder().setUser2(DataSourceUtil.getMetricName(query.getDataSource())).setUser4(query.getType()).setUser6("false");
    }

    @Override
    public Function<Result<TimeBoundaryResultValue>, Result<TimeBoundaryResultValue>> makePreComputeManipulatorFn(TimeBoundaryQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<TimeBoundaryResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<TimeBoundaryResultValue>, Object, TimeBoundaryQuery> getCacheStrategy(TimeBoundaryQuery query) {
        return new CacheStrategy<Result<TimeBoundaryResultValue>, Object, TimeBoundaryQuery>(){

            @Override
            public byte[] computeCacheKey(TimeBoundaryQuery query) {
                return ByteBuffer.allocate(2).put((byte)3).put(query.getCacheKey()).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<TimeBoundaryResultValue>, Object> prepareForCache() {
                return new Function<Result<TimeBoundaryResultValue>, Object>(){

                    public Object apply(Result<TimeBoundaryResultValue> input) {
                        return Lists.newArrayList((Object[])new Object[]{input.getTimestamp().getMillis(), input.getValue()});
                    }
                };
            }

            @Override
            public Function<Object, Result<TimeBoundaryResultValue>> pullFromCache() {
                return new Function<Object, Result<TimeBoundaryResultValue>>(){

                    public Result<TimeBoundaryResultValue> apply(Object input) {
                        List result = (List)input;
                        return new Result<TimeBoundaryResultValue>(new DateTime(result.get(0)), new TimeBoundaryResultValue(result.get(1)));
                    }
                };
            }

            @Override
            public Sequence<Result<TimeBoundaryResultValue>> mergeSequences(Sequence<Sequence<Result<TimeBoundaryResultValue>>> seqOfSequences) {
                return new MergeSequence(TimeBoundaryQueryQueryToolChest.this.getOrdering(), seqOfSequences);
            }
        };
    }

    public Ordering<Result<TimeBoundaryResultValue>> getOrdering() {
        return Ordering.natural();
    }
}

