/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.spec;

import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QuerySegmentWalker;
import io.druid.query.SegmentDescriptor;
import io.druid.query.spec.QuerySegmentSpec;
import java.util.Arrays;
import java.util.List;
import org.joda.time.Interval;

public class SpecificSegmentSpec
implements QuerySegmentSpec {
    private final SegmentDescriptor descriptor;

    public SpecificSegmentSpec(SegmentDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public List<Interval> getIntervals() {
        return Arrays.asList(this.descriptor.getInterval());
    }

    @Override
    public <T> QueryRunner<T> lookup(Query<T> query, QuerySegmentWalker walker) {
        return walker.getQueryRunnerForSegments(query, Arrays.asList(this.descriptor));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecificSegmentSpec that = (SpecificSegmentSpec)o;
        return !(this.descriptor != null ? !this.descriptor.equals((Object)that.descriptor) : that.descriptor != null);
    }

    public int hashCode() {
        return this.descriptor != null ? this.descriptor.hashCode() : 0;
    }
}

