/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.spec;

import com.google.common.base.Throwables;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Yielder;
import com.metamx.common.guava.YieldingAccumulator;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.spec.QuerySegmentSpec;
import java.io.IOException;
import java.util.concurrent.Callable;

public class SpecificSegmentQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> base;
    private final QuerySegmentSpec specificSpec;

    public SpecificSegmentQueryRunner(QueryRunner<T> base, QuerySegmentSpec specificSpec) {
        this.base = base;
        this.specificSpec = specificSpec;
    }

    @Override
    public Sequence<T> run(Query<T> input) {
        final Query<T> query = input.withQuerySegmentSpec(this.specificSpec);
        final Thread currThread = Thread.currentThread();
        final String currThreadName = currThread.getName();
        final String newName = String.format("%s_%s_%s", query.getType(), query.getDataSource(), query.getIntervals());
        final Sequence baseSequence = (Sequence)this.doNamed(currThread, currThreadName, newName, new Callable<Sequence<T>>(){

            @Override
            public Sequence<T> call() throws Exception {
                return SpecificSegmentQueryRunner.this.base.run(query);
            }
        });
        return new Sequence<T>(){

            public <OutType> OutType accumulate(final OutType initValue, final Accumulator<OutType, T> accumulator) {
                return (OutType)this.doItNamed(new Callable<OutType>(){

                    @Override
                    public OutType call() throws Exception {
                        return baseSequence.accumulate(initValue, accumulator);
                    }
                });
            }

            public <OutType> Yielder<OutType> toYielder(final OutType initValue, final YieldingAccumulator<OutType, T> accumulator) {
                return (Yielder)this.doItNamed(new Callable<Yielder<OutType>>(){

                    @Override
                    public Yielder<OutType> call() throws Exception {
                        return this.makeYielder(baseSequence.toYielder(initValue, accumulator));
                    }
                });
            }

            private <OutType> Yielder<OutType> makeYielder(final Yielder<OutType> yielder) {
                return new Yielder<OutType>(){

                    public OutType get() {
                        return yielder.get();
                    }

                    public Yielder<OutType> next(final OutType initValue) {
                        return (Yielder)this.doItNamed(new Callable<Yielder<OutType>>(){

                            @Override
                            public Yielder<OutType> call() throws Exception {
                                return yielder.next(initValue);
                            }
                        });
                    }

                    public boolean isDone() {
                        return yielder.isDone();
                    }

                    public void close() throws IOException {
                        yielder.close();
                    }
                };
            }

            private <RetType> RetType doItNamed(Callable<RetType> toRun) {
                return (RetType)SpecificSegmentQueryRunner.this.doNamed(currThread, currThreadName, newName, toRun);
            }
        };
    }

    private <RetType> RetType doNamed(Thread currThread, String currName, String newName, Callable<RetType> toRun) {
        try {
            currThread.setName(newName);
            RetType RetType = toRun.call();
            return RetType;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            currThread.setName(currName);
        }
    }
}

