/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.primitives.Longs;
import io.druid.query.Result;
import io.druid.query.select.EventHolder;
import io.druid.query.select.SelectResultValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import org.joda.time.DateTime;

public class SelectResultValueBuilder {
    private static final Comparator<EventHolder> comparator = new Comparator<EventHolder>(){

        @Override
        public int compare(EventHolder o1, EventHolder o2) {
            int retVal = Longs.compare((long)o1.getTimestamp().getMillis(), (long)o2.getTimestamp().getMillis());
            if (retVal == 0) {
                retVal = o1.getSegmentId().compareTo(o2.getSegmentId());
            }
            if (retVal == 0) {
                retVal = Integer.compare(o1.getOffset(), o2.getOffset());
            }
            return retVal;
        }
    };
    private final DateTime timestamp;
    private MinMaxPriorityQueue<EventHolder> pQueue = null;

    public SelectResultValueBuilder(DateTime timestamp, int threshold) {
        this.timestamp = timestamp;
        this.instantiatePQueue(threshold, comparator);
    }

    public void addEntry(EventHolder event) {
        this.pQueue.add((Object)event);
    }

    public Result<SelectResultValue> build() {
        ArrayList values = Lists.newArrayListWithCapacity((int)this.pQueue.size());
        LinkedHashMap pagingIdentifiers = Maps.newLinkedHashMap();
        while (!this.pQueue.isEmpty()) {
            EventHolder event = (EventHolder)this.pQueue.remove();
            pagingIdentifiers.put(event.getSegmentId(), event.getOffset());
            values.add(event);
        }
        return new Result<SelectResultValue>(this.timestamp, new SelectResultValue(pagingIdentifiers, values));
    }

    private void instantiatePQueue(int threshold, Comparator comparator) {
        this.pQueue = MinMaxPriorityQueue.orderedBy((Comparator)comparator).maximumSize(threshold).create();
    }
}

