/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;

public class PagingSpec {
    private final LinkedHashMap<String, Integer> pagingIdentifiers;
    private final int threshold;

    @JsonCreator
    public PagingSpec(@JsonProperty(value="pagingIdentifiers") LinkedHashMap<String, Integer> pagingIdentifiers, @JsonProperty(value="threshold") int threshold) {
        this.pagingIdentifiers = pagingIdentifiers == null ? new LinkedHashMap() : pagingIdentifiers;
        this.threshold = threshold;
    }

    @JsonProperty
    public Map<String, Integer> getPagingIdentifiers() {
        return this.pagingIdentifiers;
    }

    @JsonProperty
    public int getThreshold() {
        return this.threshold;
    }

    public byte[] getCacheKey() {
        byte[][] pagingKeys = new byte[this.pagingIdentifiers.size()][];
        byte[][] pagingValues = new byte[this.pagingIdentifiers.size()][];
        int index = 0;
        int pagingKeysSize = 0;
        int pagingValuesSize = 0;
        for (Map.Entry<String, Integer> entry : this.pagingIdentifiers.entrySet()) {
            pagingKeys[index] = entry.getKey().getBytes();
            pagingValues[index] = ByteBuffer.allocate(4).putInt(entry.getValue()).array();
            pagingKeysSize += pagingKeys[index].length;
            pagingValuesSize += 4;
            ++index;
        }
        byte[] thresholdBytes = ByteBuffer.allocate(4).putInt(this.threshold).array();
        ByteBuffer queryCacheKey = ByteBuffer.allocate(pagingKeysSize + pagingValuesSize + thresholdBytes.length);
        for (byte[] pagingKey : pagingKeys) {
            queryCacheKey.put(pagingKey);
        }
        for (byte[] pagingValue : pagingValues) {
            queryCacheKey.put(pagingValue);
        }
        queryCacheKey.put(thresholdBytes);
        return queryCacheKey.array();
    }

    public String toString() {
        return "PagingSpec{pagingIdentifiers=" + this.pagingIdentifiers + ", threshold=" + this.threshold + '}';
    }
}

