/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.search.search;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.druid.query.search.search.SearchQuerySpec;
import java.nio.ByteBuffer;
import java.util.List;

public class FragmentSearchQuerySpec
implements SearchQuerySpec {
    private static final byte CACHE_TYPE_ID = 2;
    private final List<String> values;

    @JsonCreator
    public FragmentSearchQuerySpec(@JsonProperty(value="values") List<String> values) {
        this.values = Lists.transform(values, (Function)new Function<String, String>(){

            public String apply(String s) {
                return s.toLowerCase();
            }
        });
    }

    @JsonProperty
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public boolean accept(String dimVal) {
        for (String value : this.values) {
            if (dimVal != null && dimVal.toLowerCase().contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public byte[] getCacheKey() {
        byte[][] valuesBytes = new byte[this.values.size()][];
        int valuesBytesSize = 0;
        int index = 0;
        for (String value : this.values) {
            valuesBytes[index] = value.getBytes();
            valuesBytesSize += valuesBytes[index].length;
            ++index;
        }
        ByteBuffer queryCacheKey = ByteBuffer.allocate(1 + valuesBytesSize).put((byte)2);
        for (byte[] bytes : valuesBytes) {
            queryCacheKey.put(bytes);
        }
        return queryCacheKey.array();
    }

    public String toString() {
        return "FragmentSearchQuerySpec{values=" + this.values + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FragmentSearchQuerySpec that = (FragmentSearchQuerySpec)o;
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    public int hashCode() {
        return this.values != null ? this.values.hashCode() : 0;
    }
}

