/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.metadata;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.common.utils.JodaUtils;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSourceUtil;
import io.druid.query.Query;
import io.druid.query.QueryConfig;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.ResultMergeQueryRunner;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.metadata.metadata.ColumnAnalysis;
import io.druid.query.metadata.metadata.SegmentAnalysis;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInterval;

public class SegmentMetadataQueryQueryToolChest
extends QueryToolChest<SegmentAnalysis, SegmentMetadataQuery> {
    private static final TypeReference<SegmentAnalysis> TYPE_REFERENCE = new TypeReference<SegmentAnalysis>(){};
    private static final byte[] SEGMENT_METADATA_CACHE_PREFIX = new byte[]{4};
    private final QueryConfig config;

    @Inject
    public SegmentMetadataQueryQueryToolChest(QueryConfig config) {
        this.config = config;
    }

    @Override
    public QueryRunner<SegmentAnalysis> mergeResults(QueryRunner<SegmentAnalysis> runner) {
        return new ResultMergeQueryRunner<SegmentAnalysis>(runner){

            @Override
            protected Ordering<SegmentAnalysis> makeOrdering(Query<SegmentAnalysis> query) {
                if (((SegmentMetadataQuery)query).isMerge()) {
                    return new Ordering<SegmentAnalysis>(){

                        public int compare(@Nullable SegmentAnalysis left, @Nullable SegmentAnalysis right) {
                            return 0;
                        }
                    };
                }
                return SegmentMetadataQueryQueryToolChest.this.getOrdering();
            }

            @Override
            protected BinaryFn<SegmentAnalysis, SegmentAnalysis, SegmentAnalysis> createMergeFn(final Query<SegmentAnalysis> inQ) {
                return new BinaryFn<SegmentAnalysis, SegmentAnalysis, SegmentAnalysis>(){
                    private final SegmentMetadataQuery query;
                    {
                        this.query = (SegmentMetadataQuery)inQ;
                    }

                    public SegmentAnalysis apply(SegmentAnalysis arg1, SegmentAnalysis arg2) {
                        if (arg1 == null) {
                            return arg2;
                        }
                        if (arg2 == null) {
                            return arg1;
                        }
                        if (!this.query.isMerge()) {
                            throw new ISE("Merging when a merge isn't supposed to happen[%s], [%s]", new Object[]{arg1, arg2});
                        }
                        ArrayList newIntervals = JodaUtils.condenseIntervals((Iterable)Iterables.concat(arg1.getIntervals(), arg2.getIntervals()));
                        Map<String, ColumnAnalysis> leftColumns = arg1.getColumns();
                        Map<String, ColumnAnalysis> rightColumns = arg2.getColumns();
                        TreeMap columns = Maps.newTreeMap();
                        HashSet rightColumnNames = Sets.newHashSet(rightColumns.keySet());
                        for (Map.Entry<String, ColumnAnalysis> entry : leftColumns.entrySet()) {
                            String columnName = entry.getKey();
                            columns.put(columnName, entry.getValue().fold(rightColumns.get(columnName)));
                            rightColumnNames.remove(columnName);
                        }
                        for (String columnName : rightColumnNames) {
                            columns.put(columnName, rightColumns.get(columnName));
                        }
                        return new SegmentAnalysis("merged", newIntervals, columns, arg1.getSize() + arg2.getSize());
                    }
                };
            }
        };
    }

    @Override
    public Sequence<SegmentAnalysis> mergeSequences(Sequence<Sequence<SegmentAnalysis>> seqOfSequences) {
        return new OrderedMergeSequence(this.getOrdering(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(SegmentMetadataQuery query) {
        int numMinutes = 0;
        for (Interval interval : query.getIntervals()) {
            numMinutes += Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }
        return new ServiceMetricEvent.Builder().setUser2(DataSourceUtil.getMetricName(query.getDataSource())).setUser4(query.getType()).setUser5(Joiner.on((String)",").join(query.getIntervals())).setUser6(String.valueOf(query.hasFilters())).setUser9(Minutes.minutes((int)numMinutes).toString());
    }

    @Override
    public Function<SegmentAnalysis, SegmentAnalysis> makePreComputeManipulatorFn(SegmentMetadataQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<SegmentAnalysis> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery> getCacheStrategy(SegmentMetadataQuery query) {
        return new CacheStrategy<SegmentAnalysis, SegmentAnalysis, SegmentMetadataQuery>(){

            @Override
            public byte[] computeCacheKey(SegmentMetadataQuery query) {
                byte[] includerBytes = query.getToInclude().getCacheKey();
                return ByteBuffer.allocate(1 + includerBytes.length).put(SEGMENT_METADATA_CACHE_PREFIX).put(includerBytes).array();
            }

            @Override
            public TypeReference<SegmentAnalysis> getCacheObjectClazz() {
                return SegmentMetadataQueryQueryToolChest.this.getResultTypeReference();
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> prepareForCache() {
                return new Function<SegmentAnalysis, SegmentAnalysis>(){

                    public SegmentAnalysis apply(@Nullable SegmentAnalysis input) {
                        return input;
                    }
                };
            }

            @Override
            public Function<SegmentAnalysis, SegmentAnalysis> pullFromCache() {
                return new Function<SegmentAnalysis, SegmentAnalysis>(){

                    public SegmentAnalysis apply(@Nullable SegmentAnalysis input) {
                        return input;
                    }
                };
            }

            @Override
            public Sequence<SegmentAnalysis> mergeSequences(Sequence<Sequence<SegmentAnalysis>> seqOfSequences) {
                return new MergeSequence(SegmentMetadataQueryQueryToolChest.this.getOrdering(), seqOfSequences);
            }
        };
    }

    private Ordering<SegmentAnalysis> getOrdering() {
        return new Ordering<SegmentAnalysis>(){

            public int compare(SegmentAnalysis left, SegmentAnalysis right) {
                return left.getId().compareTo(right.getId());
            }
        }.nullsFirst();
    }
}

