/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.MergeSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.OrderedMergeSequence;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.granularity.QueryGranularity;
import io.druid.query.CacheStrategy;
import io.druid.query.DataSource;
import io.druid.query.DataSourceUtil;
import io.druid.query.IntervalChunkingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryCacheHelper;
import io.druid.query.QueryDataSource;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.SubqueryQueryRunner;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.DimFilter;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryEngine;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexStorageAdapter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Minutes;
import org.joda.time.ReadableInterval;

public class GroupByQueryQueryToolChest
extends QueryToolChest<Row, GroupByQuery> {
    private static final byte GROUPBY_QUERY = 20;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    private static final String GROUP_BY_MERGE_KEY = "groupByMerge";
    private static final Map<String, Object> NO_MERGE_CONTEXT = ImmutableMap.of((Object)"groupByMerge", (Object)"false");
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final ObjectMapper jsonMapper;
    private GroupByQueryEngine engine;

    @Inject
    public GroupByQueryQueryToolChest(Supplier<GroupByQueryConfig> configSupplier, ObjectMapper jsonMapper, GroupByQueryEngine engine) {
        this.configSupplier = configSupplier;
        this.jsonMapper = jsonMapper;
        this.engine = engine;
    }

    @Override
    public QueryRunner<Row> mergeResults(final QueryRunner<Row> runner) {
        return new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(Query<Row> input) {
                if (input.getContextBySegment(false)) {
                    return runner.run(input);
                }
                if (Boolean.valueOf(input.getContextValue(GroupByQueryQueryToolChest.GROUP_BY_MERGE_KEY, "true")).booleanValue()) {
                    return GroupByQueryQueryToolChest.this.mergeGroupByResults((GroupByQuery)((GroupByQuery)input).withOverriddenContext(NO_MERGE_CONTEXT), runner);
                }
                return runner.run(input);
            }
        };
    }

    private Sequence<Row> mergeGroupByResults(GroupByQuery query, QueryRunner<Row> runner) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof QueryDataSource) {
            GroupByQuery subquery;
            try {
                subquery = (GroupByQuery)((QueryDataSource)dataSource).getQuery();
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Subqueries must be of type 'group by'");
            }
            Sequence<Row> subqueryResult = this.mergeGroupByResults(subquery, runner);
            ArrayList aggs = Lists.newArrayList();
            for (AggregatorFactory aggregatorFactory : query.getAggregatorSpecs()) {
                aggs.addAll(aggregatorFactory.getRequiredColumns());
            }
            GroupByQuery innerQuery = new GroupByQuery.Builder(query).setAggregatorSpecs(aggs).setInterval(subquery.getIntervals()).setPostAggregatorSpecs(Lists.newArrayList()).build();
            GroupByQuery outerQuery = new GroupByQuery.Builder(query).setLimitSpec(query.getLimitSpec().merge(subquery.getLimitSpec())).build();
            IncrementalIndexStorageAdapter adapter = new IncrementalIndexStorageAdapter(this.makeIncrementalIndex(innerQuery, subqueryResult));
            return outerQuery.applyLimit(this.engine.process(outerQuery, adapter));
        }
        return query.applyLimit(this.postAggregate(query, this.makeIncrementalIndex(query, runner.run(query))));
    }

    private Sequence<Row> postAggregate(final GroupByQuery query, IncrementalIndex index) {
        return Sequences.map((Sequence)Sequences.simple(index.iterableWithPostAggregations(query.getPostAggregatorSpecs())), (Function)new Function<Row, Row>(){

            public Row apply(Row input) {
                MapBasedRow row = (MapBasedRow)input;
                return new MapBasedRow(query.getGranularity().toDateTime(row.getTimestampFromEpoch()), row.getEvent());
            }
        });
    }

    private IncrementalIndex makeIncrementalIndex(GroupByQuery query, Sequence<Row> rows) {
        GroupByQueryConfig config = (GroupByQueryConfig)this.configSupplier.get();
        Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, config);
        return (IncrementalIndex)rows.accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
    }

    @Override
    public Sequence<Row> mergeSequences(Sequence<Sequence<Row>> seqOfSequences) {
        return new OrderedMergeSequence(Ordering.natural().nullsFirst(), seqOfSequences);
    }

    @Override
    public ServiceMetricEvent.Builder makeMetricBuilder(GroupByQuery query) {
        int numMinutes = 0;
        for (Interval interval : query.getIntervals()) {
            numMinutes += Minutes.minutesIn((ReadableInterval)interval).getMinutes();
        }
        return new ServiceMetricEvent.Builder().setUser2(DataSourceUtil.getMetricName(query.getDataSource())).setUser3(String.format("%,d dims", query.getDimensions().size())).setUser4("groupBy").setUser5(Joiner.on((String)",").join(query.getIntervals())).setUser6(String.valueOf(query.hasFilters())).setUser7(String.format("%,d aggs", query.getAggregatorSpecs().size())).setUser9(Minutes.minutes((int)numMinutes).toString());
    }

    @Override
    public Function<Row, Row> makePreComputeManipulatorFn(final GroupByQuery query, final MetricManipulationFn fn) {
        return new Function<Row, Row>(){

            public Row apply(Row input) {
                if (input instanceof MapBasedRow) {
                    MapBasedRow inputRow = (MapBasedRow)input;
                    HashMap values = Maps.newHashMap((Map)inputRow.getEvent());
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), fn.manipulate(agg, inputRow.getEvent().get(agg.getName())));
                    }
                    return new MapBasedRow(inputRow.getTimestamp(), (Map)values);
                }
                return input;
            }
        };
    }

    @Override
    public TypeReference<Row> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<Row> preMergeQueryDecoration(QueryRunner<Row> runner) {
        return new SubqueryQueryRunner<Row>(new IntervalChunkingQueryRunner<Row>(runner, ((GroupByQueryConfig)this.configSupplier.get()).getChunkPeriod()));
    }

    @Override
    public CacheStrategy<Row, Object, GroupByQuery> getCacheStrategy(final GroupByQuery query) {
        return new CacheStrategy<Row, Object, GroupByQuery>(){

            @Override
            public byte[] computeCacheKey(GroupByQuery query2) {
                DimFilter dimFilter = query2.getDimFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] aggregatorBytes = QueryCacheHelper.computeAggregatorBytes(query2.getAggregatorSpecs());
                byte[] granularityBytes = query2.getGranularity().cacheKey();
                byte[][] dimensionsBytes = new byte[query2.getDimensions().size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (DimensionSpec dimension : query2.getDimensions()) {
                    dimensionsBytes[index] = dimension.getCacheKey();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                byte[] havingBytes = query2.getHavingSpec() == null ? new byte[]{} : query2.getHavingSpec().getCacheKey();
                byte[] limitBytes = query2.getLimitSpec().getCacheKey();
                ByteBuffer buffer = ByteBuffer.allocate(1 + granularityBytes.length + filterBytes.length + aggregatorBytes.length + dimensionsBytesSize + havingBytes.length + limitBytes.length).put((byte)20).put(granularityBytes).put(filterBytes).put(aggregatorBytes);
                for (byte[] dimensionsByte : dimensionsBytes) {
                    buffer.put(dimensionsByte);
                }
                return buffer.put(havingBytes).put(limitBytes).array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Row, Object> prepareForCache() {
                return new Function<Row, Object>(){

                    public Object apply(Row input) {
                        if (input instanceof MapBasedRow) {
                            MapBasedRow row = (MapBasedRow)input;
                            ArrayList retVal = Lists.newArrayListWithCapacity((int)2);
                            retVal.add(row.getTimestamp().getMillis());
                            retVal.add(row.getEvent());
                            return retVal;
                        }
                        throw new ISE("Don't know how to cache input rows of type[%s]", new Object[]{input.getClass()});
                    }
                };
            }

            @Override
            public Function<Object, Row> pullFromCache() {
                return new Function<Object, Row>(){
                    private final QueryGranularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Row apply(Object input) {
                        Iterator results = ((List)input).iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)results.next()).longValue());
                        return new MapBasedRow(timestamp, (Map)GroupByQueryQueryToolChest.this.jsonMapper.convertValue(results.next(), (TypeReference)new TypeReference<Map<String, Object>>(){}));
                    }
                };
            }

            @Override
            public Sequence<Row> mergeSequences(Sequence<Sequence<Row>> seqOfSequences) {
                return new MergeSequence(Ordering.natural().nullsFirst(), seqOfSequences);
            }
        };
    }
}

