/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.groupby;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import io.druid.data.input.Row;
import io.druid.data.input.Rows;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.segment.incremental.IncrementalIndex;
import java.util.ArrayList;
import java.util.List;

public class GroupByQueryHelper {
    public static <T> Pair<IncrementalIndex, Accumulator<IncrementalIndex, T>> createIndexAccumulatorPair(GroupByQuery query, final GroupByQueryConfig config) {
        QueryGranularity gran = query.getGranularity();
        long timeStart = query.getIntervals().get(0).getStartMillis();
        long granTimeStart = gran.iterable(timeStart, timeStart + 1L).iterator().next();
        List aggs = Lists.transform(query.getAggregatorSpecs(), (Function)new Function<AggregatorFactory, AggregatorFactory>(){

            public AggregatorFactory apply(AggregatorFactory input) {
                return input.getCombiningFactory();
            }
        });
        final List dimensions = Lists.transform(query.getDimensions(), (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        });
        IncrementalIndex index = new IncrementalIndex(granTimeStart, gran, aggs.toArray(new AggregatorFactory[aggs.size()]));
        Accumulator accumulator = new Accumulator<IncrementalIndex, T>(){

            public IncrementalIndex accumulate(IncrementalIndex accumulated, T in) {
                if (in instanceof Row) {
                    if (accumulated.add(Rows.toCaseInsensitiveInputRow((Row)((Row)in), (List)dimensions), false) > config.getMaxResults()) {
                        throw new ISE("Computation exceeds maxRows limit[%s]", new Object[]{config.getMaxResults()});
                    }
                } else {
                    throw new ISE("Unable to accumulate something of type [%s]", new Object[]{in.getClass()});
                }
                return accumulated;
            }
        };
        return new Pair((Object)index, (Object)accumulator);
    }

    public static <T> Pair<List, Accumulator<List, T>> createBySegmentAccumulatorPair() {
        ArrayList init = Lists.newArrayList();
        Accumulator accumulator = new Accumulator<List, T>(){

            public List accumulate(List accumulated, T in) {
                accumulated.add(in);
                return accumulated;
            }
        };
        return new Pair((Object)init, (Object)accumulator);
    }
}

