/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import io.druid.query.filter.DimFilter;
import java.nio.ByteBuffer;
import java.util.List;

class DimFilterCacheHelper {
    static final byte NOOP_CACHE_ID = -4;
    static final byte SELECTOR_CACHE_ID = 0;
    static final byte AND_CACHE_ID = 1;
    static final byte OR_CACHE_ID = 2;
    static final byte NOT_CACHE_ID = 3;
    static final byte EXTRACTION_CACHE_ID = 4;
    static final byte REGEX_CACHE_ID = 5;
    static final byte SEARCH_QUERY_TYPE_ID = 6;
    static final byte JAVASCRIPT_CACHE_ID = 7;
    static final byte SPATIAL_CACHE_ID = 8;

    DimFilterCacheHelper() {
    }

    static byte[] computeCacheKey(byte cacheIdKey, List<DimFilter> filters) {
        if (filters.size() == 1) {
            return filters.get(0).getCacheKey();
        }
        byte[][] cacheKeys = new byte[filters.size()][];
        int totalSize = 0;
        int index = 0;
        for (DimFilter field : filters) {
            cacheKeys[index] = field.getCacheKey();
            totalSize += cacheKeys[index].length;
            ++index;
        }
        ByteBuffer retVal = ByteBuffer.allocate(1 + totalSize);
        retVal.put(cacheIdKey);
        for (byte[] cacheKey : cacheKeys) {
            retVal.put(cacheKey);
        }
        return retVal.array();
    }
}

