/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ibm.icu.text.SimpleDateFormat;
import io.druid.query.extraction.DimExtractionFn;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.Date;

public class TimeDimExtractionFn
implements DimExtractionFn {
    private static final byte CACHE_TYPE_ID = 0;
    private final String timeFormat;
    private final SimpleDateFormat timeFormatter;
    private final String resultFormat;
    private final SimpleDateFormat resultFormatter;

    @JsonCreator
    public TimeDimExtractionFn(@JsonProperty(value="timeFormat") String timeFormat, @JsonProperty(value="resultFormat") String resultFormat) {
        this.timeFormat = timeFormat;
        this.timeFormatter = new SimpleDateFormat(timeFormat);
        this.timeFormatter.setLenient(true);
        this.resultFormat = resultFormat;
        this.resultFormatter = new SimpleDateFormat(resultFormat);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] timeFormatBytes = this.timeFormat.getBytes();
        return ByteBuffer.allocate(1 + timeFormatBytes.length).put((byte)0).put(timeFormatBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        Date date;
        try {
            date = this.timeFormatter.parse(dimValue);
        }
        catch (ParseException e) {
            return dimValue;
        }
        return this.resultFormatter.format(date);
    }

    @JsonProperty(value="timeFormat")
    public String getTimeFormat() {
        return this.timeFormat;
    }

    @JsonProperty(value="resultFormat")
    public String getResultFormat() {
        return this.resultFormat;
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    public String toString() {
        return "TimeDimExtractionFn{timeFormat='" + this.timeFormat + '\'' + ", resultFormat='" + this.resultFormat + '\'' + '}';
    }
}

