/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.search.search.SearchQuerySpec;
import java.nio.ByteBuffer;

public class SearchQuerySpecDimExtractionFn
implements DimExtractionFn {
    private static final byte CACHE_TYPE_ID = 3;
    private final SearchQuerySpec searchQuerySpec;

    @JsonCreator
    public SearchQuerySpecDimExtractionFn(@JsonProperty(value="query") SearchQuerySpec searchQuerySpec) {
        this.searchQuerySpec = searchQuerySpec;
    }

    @JsonProperty(value="query")
    public SearchQuerySpec getSearchQuerySpec() {
        return this.searchQuerySpec;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] specBytes = this.searchQuerySpec.getCacheKey();
        return ByteBuffer.allocate(1 + specBytes.length).put((byte)3).put(specBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        return this.searchQuerySpec.accept(dimValue) ? dimValue : null;
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    public String toString() {
        return "SearchQuerySpecDimExtractionFn{searchQuerySpec=" + this.searchQuerySpec + '}';
    }
}

