/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.extraction.DimExtractionFn;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PartialDimExtractionFn
implements DimExtractionFn {
    private static final byte CACHE_TYPE_ID = 2;
    private final String expr;
    private final Pattern pattern;

    @JsonCreator
    public PartialDimExtractionFn(@JsonProperty(value="expr") String expr) {
        this.expr = expr;
        this.pattern = Pattern.compile(expr);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] exprBytes = this.expr.getBytes();
        return ByteBuffer.allocate(1 + exprBytes.length).put((byte)2).put(exprBytes).array();
    }

    @Override
    public String apply(String dimValue) {
        Matcher matcher = this.pattern.matcher(dimValue);
        return matcher.find() ? dimValue : null;
    }

    @JsonProperty(value="expr")
    public String getExpr() {
        return this.expr;
    }

    @Override
    public boolean preservesOrdering() {
        return true;
    }

    public String toString() {
        return String.format("regex_matches(%s)", this.expr);
    }
}

