/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import io.druid.query.extraction.DimExtractionFn;
import java.nio.ByteBuffer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavascriptDimExtractionFn
implements DimExtractionFn {
    private static final byte CACHE_TYPE_ID = 4;
    private final String function;
    private final Function<String, String> fn;

    private static Function<String, String> compile(String function) {
        final ContextFactory contextFactory = ContextFactory.getGlobal();
        Context context = contextFactory.enterContext();
        context.setOptimizationLevel(9);
        final ScriptableObject scope = context.initStandardObjects();
        final org.mozilla.javascript.Function fn = context.compileFunction((Scriptable)scope, function, "fn", 1, null);
        Context.exit();
        return new Function<String, String>(){

            public String apply(String input) {
                Object res;
                Context cx = Context.getCurrentContext();
                if (cx == null) {
                    cx = contextFactory.enterContext();
                }
                return (res = fn.call(cx, (Scriptable)scope, (Scriptable)scope, (Object[])new String[]{input})) != null ? Context.toString((Object)res) : null;
            }
        };
    }

    @JsonCreator
    public JavascriptDimExtractionFn(@JsonProperty(value="function") String function) {
        this.function = function;
        this.fn = JavascriptDimExtractionFn.compile(function);
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] bytes = this.function.getBytes();
        return ByteBuffer.allocate(1 + bytes.length).put((byte)4).put(bytes).array();
    }

    @Override
    public String apply(String dimValue) {
        return (String)this.fn.apply((Object)dimValue);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    public String toString() {
        return "JavascriptDimExtractionFn{function='" + this.function + '\'' + '}';
    }
}

