/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.dimension;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.DimExtractionFn;
import java.nio.ByteBuffer;

public class ExtractionDimensionSpec
implements DimensionSpec {
    private static final byte CACHE_TYPE_ID = 1;
    private final String dimension;
    private final DimExtractionFn dimExtractionFn;
    private final String outputName;

    @JsonCreator
    public ExtractionDimensionSpec(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="outputName") String outputName, @JsonProperty(value="dimExtractionFn") DimExtractionFn dimExtractionFn) {
        this.dimension = dimension;
        this.dimExtractionFn = dimExtractionFn;
        this.outputName = outputName == null ? dimension : outputName;
    }

    @Override
    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @Override
    @JsonProperty
    public String getOutputName() {
        return this.outputName;
    }

    @Override
    @JsonProperty
    public DimExtractionFn getDimExtractionFn() {
        return this.dimExtractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = this.dimension.getBytes();
        byte[] dimExtractionFnBytes = this.dimExtractionFn.getCacheKey();
        return ByteBuffer.allocate(1 + dimensionBytes.length + dimExtractionFnBytes.length).put((byte)1).put(dimensionBytes).put(dimExtractionFnBytes).array();
    }

    @Override
    public boolean preservesOrdering() {
        return this.dimExtractionFn.preservesOrdering();
    }

    public String toString() {
        return "ExtractionDimensionSpec{dimension='" + this.dimension + '\'' + ", dimExtractionFn=" + this.dimExtractionFn + ", outputName='" + this.outputName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtractionDimensionSpec that = (ExtractionDimensionSpec)o;
        if (this.dimExtractionFn != null ? !this.dimExtractionFn.equals(that.dimExtractionFn) : that.dimExtractionFn != null) {
            return false;
        }
        if (this.dimension != null ? !this.dimension.equals(that.dimension) : that.dimension != null) {
            return false;
        }
        return !(this.outputName != null ? !this.outputName.equals(that.outputName) : that.outputName != null);
    }

    public int hashCode() {
        int result = this.dimension != null ? this.dimension.hashCode() : 0;
        result = 31 * result + (this.dimExtractionFn != null ? this.dimExtractionFn.hashCode() : 0);
        result = 31 * result + (this.outputName != null ? this.outputName.hashCode() : 0);
        return result;
    }
}

