/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.post;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.metamx.common.IAE;
import io.druid.query.aggregation.PostAggregator;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArithmeticPostAggregator
implements PostAggregator {
    private static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return ((Double)o).compareTo((Double)o1);
        }
    };
    private final String name;
    private final String fnName;
    private final List<PostAggregator> fields;
    private final Ops op;

    @JsonCreator
    public ArithmeticPostAggregator(@JsonProperty(value="name") String name, @JsonProperty(value="fn") String fnName, @JsonProperty(value="fields") List<PostAggregator> fields) {
        this.name = name;
        this.fnName = fnName;
        this.fields = fields;
        if (fields.size() <= 1) {
            throw new IAE("Illegal number of fields[%s], must be > 1", new Object[]{fields.size()});
        }
        this.op = Ops.lookup(fnName);
        if (this.op == null) {
            throw new IAE("Unknown operation[%s], known operations[%s]", new Object[]{fnName, Ops.getFns()});
        }
    }

    @Override
    public Set<String> getDependentFields() {
        HashSet dependentFields = Sets.newHashSet();
        for (PostAggregator field : this.fields) {
            dependentFields.addAll(field.getDependentFields());
        }
        return dependentFields;
    }

    @Override
    public Comparator getComparator() {
        return COMPARATOR;
    }

    @Override
    public Object compute(Map<String, Object> values) {
        Iterator<PostAggregator> fieldsIter = this.fields.iterator();
        double retVal = 0.0;
        if (fieldsIter.hasNext()) {
            retVal = ((Number)fieldsIter.next().compute(values)).doubleValue();
            while (fieldsIter.hasNext()) {
                retVal = this.op.compute(retVal, ((Number)fieldsIter.next().compute(values)).doubleValue());
            }
        }
        return retVal;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="fn")
    public String getFnName() {
        return this.fnName;
    }

    @JsonProperty
    public List<PostAggregator> getFields() {
        return this.fields;
    }

    public String toString() {
        return "ArithmeticPostAggregator{name='" + this.name + '\'' + ", fnName='" + this.fnName + '\'' + ", fields=" + this.fields + ", op=" + (Object)((Object)this.op) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticPostAggregator that = (ArithmeticPostAggregator)o;
        if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) {
            return false;
        }
        if (this.fnName != null ? !this.fnName.equals(that.fnName) : that.fnName != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.op == that.op;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.fnName != null ? this.fnName.hashCode() : 0);
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        result = 31 * result + (this.op != null ? this.op.hashCode() : 0);
        return result;
    }

    private static enum Ops {
        PLUS("+"){

            @Override
            double compute(double lhs, double rhs) {
                return lhs + rhs;
            }
        }
        ,
        MINUS("-"){

            @Override
            double compute(double lhs, double rhs) {
                return lhs - rhs;
            }
        }
        ,
        MULT("*"){

            @Override
            double compute(double lhs, double rhs) {
                return lhs * rhs;
            }
        }
        ,
        DIV("/"){

            @Override
            double compute(double lhs, double rhs) {
                return rhs == 0.0 ? 0.0 : lhs / rhs;
            }
        };

        private static final Map<String, Ops> lookupMap;
        private final String fn;

        private Ops(String fn) {
            this.fn = fn;
        }

        public String getFn() {
            return this.fn;
        }

        abstract double compute(double var1, double var3);

        static Ops lookup(String fn) {
            return lookupMap.get(fn);
        }

        static Set<String> getFns() {
            return lookupMap.keySet();
        }

        static {
            lookupMap = Maps.newHashMap();
            for (Ops op : Ops.values()) {
                lookupMap.put(op.getFn(), op);
            }
        }
    }
}

