/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.cardinality;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.segment.DimensionSelector;
import io.druid.segment.data.IndexedInts;
import java.util.Arrays;
import java.util.List;

public class CardinalityAggregator
implements Aggregator {
    private static final String NULL_STRING = "\u0000";
    private final String name;
    private final List<DimensionSelector> selectorList;
    private final boolean byRow;
    private static final HashFunction hashFn = Hashing.murmur3_128();
    public static final char SEPARATOR = '\u0001';
    private HyperLogLogCollector collector;

    protected static void hashRow(List<DimensionSelector> selectorList, HyperLogLogCollector collector) {
        Hasher hasher = hashFn.newHasher();
        for (int k = 0; k < selectorList.size(); ++k) {
            int i;
            DimensionSelector selector;
            IndexedInts row;
            int size;
            if (k != 0) {
                hasher.putByte((byte)0);
            }
            if ((size = (row = (selector = selectorList.get(k)).getRow()).size()) == 1) {
                String value = selector.lookupName(row.get(0));
                hasher.putUnencodedChars((CharSequence)(value != null ? value : NULL_STRING));
                continue;
            }
            if (size == 0) continue;
            Object[] values = new String[size];
            for (i = 0; i < size; ++i) {
                String value = selector.lookupName(row.get(i));
                values[i] = value != null ? value : NULL_STRING;
            }
            Arrays.sort(values);
            for (i = 0; i < size; ++i) {
                if (i != 0) {
                    hasher.putChar('\u0001');
                }
                hasher.putUnencodedChars((CharSequence)values[i]);
            }
        }
        collector.add(hasher.hash().asBytes());
    }

    protected static void hashValues(List<DimensionSelector> selectors, HyperLogLogCollector collector) {
        for (DimensionSelector selector : selectors) {
            for (Integer index : selector.getRow()) {
                String value = selector.lookupName(index);
                collector.add(hashFn.hashUnencodedChars((CharSequence)(value == null ? NULL_STRING : value)).asBytes());
            }
        }
    }

    public CardinalityAggregator(String name, List<DimensionSelector> selectorList, boolean byRow) {
        this.name = name;
        this.selectorList = selectorList;
        this.collector = HyperLogLogCollector.makeLatestCollector();
        this.byRow = byRow;
    }

    @Override
    public void aggregate() {
        if (this.byRow) {
            CardinalityAggregator.hashRow(this.selectorList, this.collector);
        } else {
            CardinalityAggregator.hashValues(this.selectorList, this.collector);
        }
    }

    @Override
    public void reset() {
        this.collector = HyperLogLogCollector.makeLatestCollector();
    }

    @Override
    public Object get() {
        return this.collector;
    }

    @Override
    public float getFloat() {
        throw new UnsupportedOperationException("CardinalityAggregator does not support getFloat()");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Aggregator clone() {
        return new CardinalityAggregator(this.name, this.selectorList, this.byRow);
    }

    @Override
    public void close() {
    }
}

