/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation;

import io.druid.query.aggregation.BufferAggregator;
import io.druid.segment.FloatColumnSelector;
import java.nio.ByteBuffer;

public class LongSumBufferAggregator
implements BufferAggregator {
    private final FloatColumnSelector selector;

    public LongSumBufferAggregator(FloatColumnSelector selector) {
        this.selector = selector;
    }

    @Override
    public void init(ByteBuffer buf, int position) {
        buf.putLong(position, 0L);
    }

    @Override
    public void aggregate(ByteBuffer buf, int position) {
        buf.putLong(position, buf.getLong(position) + (long)this.selector.get());
    }

    @Override
    public Object get(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    @Override
    public float getFloat(ByteBuffer buf, int position) {
        return buf.getLong(position);
    }

    @Override
    public void close() {
    }
}

