/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import io.druid.query.DataSource;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.UnionDataSource;

public class UnionQueryRunner<T>
implements QueryRunner<T> {
    private final QueryRunner<T> baseRunner;
    private final QueryToolChest<T, Query<T>> toolChest;

    public UnionQueryRunner(QueryRunner<T> baseRunner, QueryToolChest<T, Query<T>> toolChest) {
        this.baseRunner = baseRunner;
        this.toolChest = toolChest;
    }

    @Override
    public Sequence<T> run(final Query<T> query) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof UnionDataSource) {
            return this.toolChest.mergeSequences(Sequences.simple((Iterable)Lists.transform(((UnionDataSource)dataSource).getDataSources(), (Function)new Function<DataSource, Sequence<T>>(){

                public Sequence<T> apply(DataSource singleSource) {
                    return UnionQueryRunner.this.baseRunner.run(query.withDataSource(singleSource));
                }
            })));
        }
        return this.baseRunner.run(query);
    }
}

