/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.concurrent.ExecutorServiceConfig;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.query.PrioritizedCallable;
import io.druid.query.PrioritizedRunnable;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class PrioritizedExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    private final ListeningExecutorService delegate;
    private final BlockingQueue<Runnable> delegateQueue;
    private final boolean allowRegularTasks;
    private final int defaultPriority;

    public static PrioritizedExecutorService create(Lifecycle lifecycle, ExecutorServiceConfig config) {
        final PrioritizedExecutorService service = new PrioritizedExecutorService(new ThreadPoolExecutor(config.getNumThreads(), config.getNumThreads(), 0L, TimeUnit.MILLISECONDS, new PriorityBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat(config.getFormatString()).build()));
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
            }

            public void stop() {
                service.shutdownNow();
            }
        });
        return service;
    }

    public PrioritizedExecutorService(ThreadPoolExecutor threadPoolExecutor) {
        this(threadPoolExecutor, false, 0);
    }

    public PrioritizedExecutorService(ThreadPoolExecutor threadPoolExecutor, boolean allowRegularTasks, int defaultPriority) {
        this.delegate = MoreExecutors.listeningDecorator((ExecutorService)((ExecutorService)Preconditions.checkNotNull((Object)threadPoolExecutor)));
        this.delegateQueue = threadPoolExecutor.getQueue();
        this.allowRegularTasks = allowRegularTasks;
        this.defaultPriority = defaultPriority;
    }

    protected <T> PrioritizedListenableFutureTask<T> newTaskFor(Runnable runnable, T value) {
        Preconditions.checkArgument((this.allowRegularTasks || runnable instanceof PrioritizedRunnable ? 1 : 0) != 0, (Object)"task does not implement PrioritizedRunnable");
        return PrioritizedListenableFutureTask.create(ListenableFutureTask.create((Runnable)runnable, value), runnable instanceof PrioritizedRunnable ? ((PrioritizedRunnable)runnable).getPriority() : this.defaultPriority);
    }

    protected <T> PrioritizedListenableFutureTask<T> newTaskFor(Callable<T> callable) {
        Preconditions.checkArgument((this.allowRegularTasks || callable instanceof PrioritizedCallable ? 1 : 0) != 0, (Object)"task does not implement PrioritizedCallable");
        return PrioritizedListenableFutureTask.create(ListenableFutureTask.create(callable), callable instanceof PrioritizedCallable ? ((PrioritizedCallable)callable).getPriority() : this.defaultPriority);
    }

    public ListenableFuture<?> submit(Runnable task) {
        return (ListenableFuture)super.submit(task);
    }

    public <T> ListenableFuture<T> submit(Runnable task, @Nullable T result) {
        return (ListenableFuture)super.submit(task, result);
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return (ListenableFuture)super.submit(task);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(runnable);
    }

    public int getQueueSize() {
        return this.delegateQueue.size();
    }

    public static class PrioritizedListenableFutureTask<V>
    implements RunnableFuture<V>,
    ListenableFuture<V>,
    PrioritizedRunnable,
    Comparable<PrioritizedListenableFutureTask> {
        private final ListenableFutureTask<V> delegate;
        private final int priority;

        public static <V> PrioritizedListenableFutureTask<V> create(PrioritizedRunnable task, @Nullable V result) {
            return new PrioritizedListenableFutureTask<V>(ListenableFutureTask.create((Runnable)task, result), task.getPriority());
        }

        public static <V> PrioritizedListenableFutureTask<?> create(PrioritizedCallable<V> callable) {
            return new PrioritizedListenableFutureTask<V>(ListenableFutureTask.create(callable), callable.getPriority());
        }

        public static <V> PrioritizedListenableFutureTask<V> create(ListenableFutureTask<V> task, int priority) {
            return new PrioritizedListenableFutureTask<V>(task, priority);
        }

        PrioritizedListenableFutureTask(ListenableFutureTask<V> delegate, int priority) {
            this.delegate = delegate;
            this.priority = priority;
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return (V)this.delegate.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (V)this.delegate.get(timeout, unit);
        }

        public void addListener(Runnable listener, Executor executor) {
            this.delegate.addListener(listener, executor);
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public int compareTo(PrioritizedListenableFutureTask otherTask) {
            return -Ints.compare((int)this.getPriority(), (int)otherTask.getPriority());
        }
    }
}

