/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.util.concurrent.ForwardingListeningExecutorService;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.PrioritizedExecutorService;
import java.util.concurrent.Callable;

public class MetricsEmittingExecutorService
extends ForwardingListeningExecutorService {
    private final ListeningExecutorService delegate;
    private final ServiceEmitter emitter;
    private final ServiceMetricEvent.Builder metricBuilder;

    public MetricsEmittingExecutorService(ListeningExecutorService delegate, ServiceEmitter emitter, ServiceMetricEvent.Builder metricBuilder) {
        this.delegate = delegate;
        this.emitter = emitter;
        this.metricBuilder = metricBuilder;
    }

    protected ListeningExecutorService delegate() {
        return this.delegate;
    }

    public <T> ListenableFuture<T> submit(Callable<T> tCallable) {
        this.emitMetrics();
        return this.delegate.submit(tCallable);
    }

    public void execute(Runnable runnable) {
        this.emitMetrics();
        this.delegate.execute(runnable);
    }

    private void emitMetrics() {
        if (this.delegate instanceof PrioritizedExecutorService) {
            this.emitter.emit(this.metricBuilder.build("exec/backlog", (Number)((PrioritizedExecutorService)this.delegate).getQueueSize()));
        }
    }
}

