/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.Pair;
import com.metamx.common.guava.Accumulator;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import io.druid.data.input.Row;
import io.druid.query.AbstractPrioritizedCallable;
import io.druid.query.Query;
import io.druid.query.QueryInterruptedException;
import io.druid.query.QueryRunner;
import io.druid.query.QueryWatcher;
import io.druid.query.groupby.GroupByQuery;
import io.druid.query.groupby.GroupByQueryConfig;
import io.druid.query.groupby.GroupByQueryHelper;
import io.druid.segment.incremental.IncrementalIndex;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class GroupByParallelQueryRunner<T>
implements QueryRunner<T> {
    private static final Logger log = new Logger(GroupByParallelQueryRunner.class);
    private final Iterable<QueryRunner<T>> queryables;
    private final ListeningExecutorService exec;
    private final Supplier<GroupByQueryConfig> configSupplier;
    private final QueryWatcher queryWatcher;

    public GroupByParallelQueryRunner(ExecutorService exec, Supplier<GroupByQueryConfig> configSupplier, QueryWatcher queryWatcher, Iterable<QueryRunner<T>> queryables) {
        this.exec = MoreExecutors.listeningDecorator((ExecutorService)exec);
        this.queryWatcher = queryWatcher;
        this.queryables = Iterables.unmodifiableIterable((Iterable)Iterables.filter(queryables, (Predicate)Predicates.notNull()));
        this.configSupplier = configSupplier;
    }

    @Override
    public Sequence<T> run(final Query<T> queryParam) {
        GroupByQuery query = (GroupByQuery)queryParam;
        final Pair indexAccumulatorPair = GroupByQueryHelper.createIndexAccumulatorPair(query, (GroupByQueryConfig)this.configSupplier.get());
        final Pair bySegmentAccumulatorPair = GroupByQueryHelper.createBySegmentAccumulatorPair();
        final boolean bySegment = query.getContextBySegment(false);
        final int priority = query.getContextPriority(0);
        if (Iterables.isEmpty(this.queryables)) {
            log.warn("No queryables found.", new Object[0]);
        }
        ListenableFuture futures = Futures.allAsList((Iterable)Lists.newArrayList((Iterable)Iterables.transform(this.queryables, (Function)new Function<QueryRunner<T>, ListenableFuture<Void>>(){

            public ListenableFuture<Void> apply(final QueryRunner<T> input) {
                return GroupByParallelQueryRunner.this.exec.submit((Callable)new AbstractPrioritizedCallable<Void>(priority){

                    @Override
                    public Void call() throws Exception {
                        try {
                            if (bySegment) {
                                input.run(queryParam).accumulate(bySegmentAccumulatorPair.lhs, (Accumulator)bySegmentAccumulatorPair.rhs);
                            } else {
                                input.run(queryParam).accumulate(indexAccumulatorPair.lhs, (Accumulator)indexAccumulatorPair.rhs);
                            }
                            return null;
                        }
                        catch (QueryInterruptedException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                        catch (Exception e) {
                            log.error((Throwable)e, "Exception with one of the sequences!", new Object[0]);
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                });
            }
        })));
        try {
            this.queryWatcher.registerQuery(query, futures);
            Number timeout = query.getContextValue("timeout", null);
            if (timeout == null) {
                futures.get();
            } else {
                futures.get(timeout.longValue(), TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e, "Query interrupted, cancelling pending results, query id [%s]", new Object[]{query.getId()});
            futures.cancel(true);
            throw new QueryInterruptedException("Query interrupted");
        }
        catch (CancellationException e) {
            throw new QueryInterruptedException("Query cancelled");
        }
        catch (TimeoutException e) {
            log.info("Query timeout, cancelling pending results for query id [%s]", new Object[]{query.getId()});
            futures.cancel(true);
            throw new QueryInterruptedException("Query timeout");
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
        if (bySegment) {
            return Sequences.simple((Iterable)((Iterable)bySegmentAccumulatorPair.lhs));
        }
        return Sequences.simple((Iterable)Iterables.transform(((IncrementalIndex)indexAccumulatorPair.lhs).iterableWithPostAggregations(null), (Function)new Function<Row, T>(){

            public T apply(Row input) {
                return input;
            }
        }));
    }
}

