/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.logger.Logger;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;

public class PropertiesModule
implements Module {
    private static final Logger log = new Logger(PropertiesModule.class);
    private final String propertiesFile;

    public PropertiesModule(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Binder binder) {
        Properties props;
        block8: {
            Properties fileProps = new Properties();
            Properties systemProps = System.getProperties();
            props = new Properties(fileProps);
            props.putAll((Map<?, ?>)systemProps);
            InputStream stream = ClassLoader.getSystemResourceAsStream(this.propertiesFile);
            try {
                File workingDirectoryFile;
                if (stream == null && (workingDirectoryFile = new File(systemProps.getProperty("druid.properties.file", this.propertiesFile))).exists()) {
                    stream = new BufferedInputStream(new FileInputStream(workingDirectoryFile));
                }
                if (stream == null) break block8;
                log.info("Loading properties from %s", new Object[]{this.propertiesFile});
                try {
                    fileProps.load(new InputStreamReader(stream, Charsets.UTF_8));
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
            catch (FileNotFoundException e) {
                log.wtf((Throwable)e, "This can only happen if the .exists() call lied.  That's f'd up.", new Object[0]);
            }
            finally {
                CloseQuietly.close((Closeable)stream);
            }
        }
        binder.bind(Properties.class).toInstance((Object)props);
    }
}

