/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.druid.guice.ConfigModule;
import io.druid.guice.DruidGuiceExtensions;
import io.druid.guice.DruidSecondaryModule;
import io.druid.guice.ExtensionsConfig;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.PropertiesModule;
import io.druid.jackson.JacksonModule;
import java.util.ArrayList;

public class GuiceInjectors {
    public static Injector makeStartupInjector() {
        return Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new JacksonModule(), new PropertiesModule("runtime.properties"), new ConfigModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(DruidSecondaryModule.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.extensions", ExtensionsConfig.class);
            }
        }});
    }

    public static Injector makeStartupInjectorWithModules(Iterable<Module> modules) {
        ArrayList theModules = Lists.newArrayList();
        theModules.add(new DruidGuiceExtensions());
        theModules.add(new JacksonModule());
        theModules.add(new PropertiesModule("runtime.properties"));
        theModules.add(new ConfigModule());
        theModules.add(new Module(){

            public void configure(Binder binder) {
                binder.bind(DruidSecondaryModule.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.extensions", ExtensionsConfig.class);
            }
        });
        for (Module theModule : modules) {
            theModules.add(theModule);
        }
        return Guice.createInjector((Iterable)theModules);
    }
}

