/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.http.client.pool;

import com.google.common.base.Throwables;
import com.metamx.http.client.netty.HandshakeRememberingSslHandler;
import com.metamx.http.client.pool.ResourceFactory;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;

public class ChannelResourceFactory
implements ResourceFactory<String, ChannelFuture> {
    private static final Logger log = Logger.getLogger(ChannelResourceFactory.class);
    private final ClientBootstrap bootstrap;
    private final SSLContext sslContext;

    public ChannelResourceFactory(ClientBootstrap bootstrap) {
        this(bootstrap, null);
    }

    public ChannelResourceFactory(ClientBootstrap bootstrap, SSLContext sslContext) {
        this.bootstrap = bootstrap;
        this.sslContext = sslContext;
    }

    @Override
    public ChannelFuture generate(String hostname) {
        log.info((Object)String.format("Generating: %s", hostname));
        URL url = null;
        try {
            url = new URL(hostname);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        ChannelFuture retVal = this.bootstrap.connect((SocketAddress)new InetSocketAddress(url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort()));
        if ("https".equals(url.getProtocol())) {
            if (this.sslContext == null) {
                throw new IllegalStateException("No sslContext set, cannot do https");
            }
            SSLEngine sslEngine = this.sslContext.createSSLEngine();
            sslEngine.setUseClientMode(true);
            final HandshakeRememberingSslHandler sslHandler = new HandshakeRememberingSslHandler(sslEngine);
            ChannelPipeline pipeline = retVal.getChannel().getPipeline();
            pipeline.addFirst("ssl", (ChannelHandler)sslHandler);
            retVal.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    sslHandler.getHandshakeFutureOrHandshake();
                }
            });
        }
        return retVal;
    }

    @Override
    public boolean isGood(ChannelFuture resource) {
        Channel channel = resource.awaitUninterruptibly().getChannel();
        boolean isConnected = channel.isConnected();
        boolean isOpen = channel.isOpen();
        boolean isHandshook = true;
        HandshakeRememberingSslHandler sslHandler = (HandshakeRememberingSslHandler)channel.getPipeline().get(HandshakeRememberingSslHandler.class);
        if (sslHandler != null) {
            try {
                sslHandler.getHandshakeFutureOrHandshake().await();
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("isGood = isConnected[%s] && isOpen[%s]", isConnected, isOpen));
        }
        return isConnected && isOpen && isHandshook;
    }

    @Override
    public void close(ChannelFuture resource) {
        log.trace((Object)"Closing");
        resource.awaitUninterruptibly().getChannel().close();
    }
}

