/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.metamx.common.IAE;
import com.metamx.common.logger.Logger;
import com.metamx.common.parsers.ParserUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TimestampParser {
    private static final Logger log = new Logger(TimestampParser.class);

    public static Function<String, DateTime> createTimestampParser(String format) {
        if (format.equalsIgnoreCase("auto")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    for (int i = 0; i < input.length(); ++i) {
                        if (input.charAt(i) >= '0' && input.charAt(i) <= '9') continue;
                        return new DateTime((Object)ParserUtils.stripQuotes(input));
                    }
                    return new DateTime(Long.parseLong(input));
                }
            };
        }
        if (format.equalsIgnoreCase("iso")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return new DateTime((Object)ParserUtils.stripQuotes(input));
                }
            };
        }
        if (format.equalsIgnoreCase("posix")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return new DateTime(Long.parseLong(ParserUtils.stripQuotes(input)) * 1000L);
                }
            };
        }
        if (format.equalsIgnoreCase("ruby")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    Double ts = Double.parseDouble(ParserUtils.stripQuotes(input));
                    Long jts = ts.longValue() * 1000L;
                    return new DateTime((Object)jts);
                }
            };
        }
        if (format.equalsIgnoreCase("millis")) {
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return new DateTime(Long.parseLong(ParserUtils.stripQuotes(input)));
                }
            };
        }
        try {
            final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
            return new Function<String, DateTime>(){

                public DateTime apply(String input) {
                    Preconditions.checkArgument((input != null && !input.isEmpty() ? 1 : 0) != 0, (Object)"null timestamp");
                    return formatter.parseDateTime(ParserUtils.stripQuotes(input));
                }
            };
        }
        catch (Exception e) {
            throw new IAE(e, "Unable to parse timestamps with format [%s]", format);
        }
    }
}

