/*
 * Decompiled with CFR 0.152.
 */
package com.metamx.common.parsers;

import com.google.common.base.Function;
import com.google.common.collect.Sets;
import com.metamx.common.parsers.ParseException;
import com.metamx.common.parsers.TimestampParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.joda.time.DateTime;

public class ParserUtils {
    public static final Function<String, String> nullEmptyStringFunction = new Function<String, String>(){

        public String apply(String input) {
            if (input == null || input.isEmpty()) {
                return null;
            }
            return input;
        }
    };

    public static ArrayList<String> generateFieldNames(int length) {
        ArrayList<String> names = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            names.add("column_" + (i + 1));
        }
        return names;
    }

    public static Function<String, DateTime> createTimestampParser(String format) {
        return TimestampParser.createTimestampParser(format);
    }

    public static Set<String> findDuplicates(Iterable<String> fieldNames) {
        HashSet duplicates = Sets.newHashSet();
        HashSet uniqueNames = Sets.newHashSet();
        Iterator<String> iter = fieldNames.iterator();
        while (iter.hasNext()) {
            String next = iter.next().toLowerCase();
            if (uniqueNames.contains(next)) {
                duplicates.add(next);
            }
            uniqueNames.add(next);
        }
        return duplicates;
    }

    public static void validateFields(Iterable<String> fieldNames) {
        Set<String> duplicates = ParserUtils.findDuplicates(fieldNames);
        if (!duplicates.isEmpty()) {
            throw new ParseException("Duplicate column entries found : %s", duplicates.toString());
        }
    }

    public static String stripQuotes(String input) {
        if ((input = input.trim()).charAt(0) == '\"' && input.charAt(input.length() - 1) == '\"') {
            input = input.substring(1, input.length() - 1).trim();
        }
        return input;
    }
}

